local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_node('pmb_liquids:ice', {
    description = S("Ice"),
    _tt_long_desc = S("Normal ice, inconspicuously made of dihydrogen monoxide"),
    groups = { full_solid = 1, item_ice = 1, oddly_breakable_by_hand = 1, solid = 1, slippery = 1, suffocates = 2, ice = 1,  silk_touchable = 1 },
    drawtype = "glasslike",
    sunlight_propagates = true,
    paramtype = "light",
    tiles = { {name = "pmb_ice.png^[opacity:200",}},
    backface_culling = true,
    use_texture_alpha = "blend",
    sounds = pmb_sounds.default_stone(),
})

