local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

pmb_animals = {}


function pmb_animals.do_sound(self, name, gain)
    minetest.sound_play(("pmb_animals_"..name), {
        gain = gain or 1,
        pos = self.object:get_pos(),
        object = self.object,
        pitch = (math.random()*0.2) + 0.9
    })
end

dofile(mod_path .. DIR_DELIM .. "items" .. DIR_DELIM .. "animal_items.lua")
dofile(mod_path .. DIR_DELIM .. "mobs" .. DIR_DELIM .. "wolf.lua")
dofile(mod_path .. DIR_DELIM .. "mobs" .. DIR_DELIM .. "deer.lua")

-- set mobcap
if pmb_mob_spawn and pmb_mob_spawn.cap.nature then
    pmb_mob_spawn.cap.nature.max = 40
end
