local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


local function ends_in(input, ending)
  if string.sub(input, string.len(input) - (string.len(ending)-1), string.len(input)) == ending then
    return true
  end
  return false
end

local function test_for_break_me(pos, cause, user, count, payload)
  -- if not can_tree_fell then return false end
  if cause == "treefeller" and payload and payload.start_pos then
    local cpos = vector.new(pos.x, payload.start_pos.y, pos.z)
    if pmb_util.math.dist2(cpos, payload.start_pos) < (6.4)^2 then
      local node = minetest.get_node(pos)
      local drops = minetest.get_node_drops(node, payload.tool_name)
      minetest.set_node(pos, {name="air"})
      minetest.fix_light(pos, pos)
      for i, stack in pairs(drops) do
        local p = vector.offset(pos,
          (math.random()*2-1) * 0.5,
          (math.random()*2-1) * 0.5,
          (math.random()*2-1) * 0.5
        )
        minetest.add_item(p, stack)
      end
      if ends_in(node.name, "_mesh_leaves") then
        local n = minetest.find_node_near(pos, 3, {"group:mesh_leaves"})
        if n then
          minetest.after(2, test_for_break_me, n, cause, user, count-1, payload)
        end
        return end
      return payload
    end
  elseif cause == "treefeller_start" and minetest.is_player(user) then
    local wieldstack = user:get_wielded_item()
    local wieldname = wieldstack:get_name()
    if minetest.get_item_group(wieldname, "treefeller") > 0 then
      pmb_node_update.update_node_propagate(pos, "treefeller", user, 30, 0.2, {
        start_pos = pos,
        tool_name = wieldname
      })
      return
    end
  end
end



pmb_wood = {}

local log_fuel = 10

local planks_per_log = 4
function pmb_wood.register_planks(name, tiles)
  local node_name = string.lower(name)
  minetest.register_node('pmb_wood:' .. node_name .. '_planks', {
    description = S(name.." Planks"),
    groups = {
      full_solid = 1, oddly_breakable_by_hand = 1, choppy = 1, solid = 1, suffocates = 2,
      wood = 1, ["item_"..name.."_planks"] = 1, planks = 1, flammable = 1, fuel = log_fuel/2 },
    tiles = tiles,
    sounds = pmb_sounds.default_wood(),
  })
  minetest.register_craft({
    output = 'pmb_wood:' .. node_name .. '_planks ' .. planks_per_log,
    recipe = {
      {'pmb_wood:' .. node_name .. '_log'},
    },
  })
end


local plank_box = {
  -8/16,   -8/16, -8/16,
  8/16,   -4/16,  8/16
}
-- local plank_box = {
--   -0.5, -0.5,  4/16,
--   0.5,   0.5,  8/16,
-- }
local plank_per_planks = 2
function pmb_wood.register_plank(name, tiles)
  local node_name = string.lower(name)
  minetest.register_node('pmb_wood:' .. node_name .. '_plank', {
    description = S("Single "..name.." Plank"),
    groups = {
      oddly_breakable_by_hand = 1, choppy = 1, solid = 1, wood = 1, shape = 1,
      ["item_"..name.."_plank"] = 1, plank = 1, flammable = 1, fuel = log_fuel/4 },
    drawtype = "nodebox",
    paramtype = "light",
    sunlight_propagates = false,
    paramtype2 = "facedir",
    node_box = {
      type = "fixed",
      fixed = plank_box,
    },
    tiles = tiles,
    sounds = pmb_sounds.default_wood(),
    on_place = pmb_util.rotate_and_place,
  })
  minetest.register_craft({
    output = 'pmb_wood:' .. node_name .. '_plank ' .. plank_per_planks,
    recipe = {
      {'pmb_wood:' .. node_name .. '_planks'},
    },
  })
end


function pmb_wood.register_log(name, tiles)
  local node_name = string.lower(name)
  minetest.register_node('pmb_wood:' .. node_name .. '_log', {
    description = S(name.." Log"),
    groups = {
      full_solid = 1, nature = 1, oddly_breakable_by_hand = 2, choppy = 1, solid = 1,
      suffocates = 2, wood = 1, ["item_"..name.."_log"] = 1, wood_log = 1, flammable = 1, fuel = log_fuel },
    tiles = tiles,
    sounds = pmb_sounds.default_wood_log(),
    paramtype2 = "facedir",
    on_place = pmb_util.rotate_and_place,
    _on_node_update = test_for_break_me,
    after_dig_node = function(pos, oldnode, oldmetadata, digger)
      test_for_break_me(pos, "treefeller_start", digger, 1)
    end,
  })
  pmb_util.register_slab( 'pmb_wood:' .. node_name .. '_log')
  pmb_util.register_post( 'pmb_wood:' .. node_name .. '_log')
end

local function leaf_decay(pos)
  if minetest.get_node_timer(pos):is_started() then return
  else minetest.get_node_timer(pos):stop() end

  pmb_util.did_abm("leaf decay")

  local n = minetest.find_node_near(pos, 3, {"group:wood_log"})
  if n then return false end
  n = minetest.find_node_near(pos, 3, {"group:leaf_decay"})
  if n and not minetest.get_node_timer(n):is_started() then
    minetest.get_node_timer(n):start(math.random(1,4))
  end
  minetest.dig_node(pos)
  return false
end

function pmb_wood.leaves_on_update(pos, cause, user, count, payload)
  local nt = minetest.get_node_timer(pos)
  if nt:is_started() then return false end
  nt:start(math.random(1,2))
  return test_for_break_me(pos, cause, user, count, payload)
end

function pmb_wood.register_leaves(name, tiles, tiles_simple)
  local node_name = string.lower(name)
  local drop = {
    max_items = 1,
    items = {
      {
        items = {'pmb_trees:' .. node_name .. '_sapling'},
        rarity = 35,
      },
      {
        items = {'pmb_items:stick'},
        rarity = 30,
      },
    },
  }
  minetest.register_node('pmb_wood:' .. node_name .. '_solid_leaves', {
    description = S(name.." Leaves"),
    -- drawtype = "allfaces_optional",
    waving = 1,
    tiles = tiles_simple,
    -- special_tiles = tiles_simple,
    -- paramtype = "light",
    groups = {
      oddly_breakable_by_hand = 1, nature = 1, snappy = 1, solid = 1, suffocates = 0,
      leaves = 1, leaf_decay = 1, ["item_"..name.."_leaves"] = 1, flammable = 1 },
    is_ground_content = false,
    drop = drop,
    sounds = pmb_sounds.default_plant(), -- #TODO add leaf sounds
    _on_node_update = pmb_wood.leaves_on_update,
    on_timer = leaf_decay,
  })
  minetest.register_node('pmb_wood:' .. node_name .. '_mesh_leaves', {
    description = S(name.." Mesh Leaves"),
    drawtype = "mesh",
    mesh = "pmb_meshleaves_3poly.b3d",
    use_texture_alpha = "clip",
    walkable = false,
    waving = 1,
    tiles = tiles,
    special_tiles = tiles_simple,
    paramtype = "light",
    paramtype2 = "degrotate",
    groups = {
      oddly_breakable_by_hand = 1, nature = 1, snappy = 1, solid = 1, suffocates = 0,
      leaves = 1, mesh_leaves = 1, leaf_decay = 1, ["item_"..name.."_leaves"] = 1, flammable = 1 },
    is_ground_content = false,
    drop = drop,
    sounds = pmb_sounds.default_plant(), -- #TODO add leaf sounds
    _on_node_update = pmb_wood.leaves_on_update,
    on_timer = leaf_decay,
    on_construct =function(pos)
        minetest.swap_node(pos, {
            name = 'pmb_wood:' .. node_name .. '_mesh_leaves',
            param2 = math.random(0, 239)
        })
    end,
  })
end




-- deprecated, for compat only
function pmb_wood.register_leaves_old(name, tiles, tiles_simple)
  local node_name = string.lower(name)
  minetest.register_node('pmb_wood:' .. node_name .. '_leaves', {
    description = S(name.." Leaves"),
    drawtype = "allfaces_optional",
    waving = 1,
    tiles = tiles,
    special_tiles = tiles_simple,
    paramtype = "light",
    groups = {
      oddly_breakable_by_hand = 1, nature = 1, snappy = 1, solid = 1, suffocates = 0,
      leaves = 1, leaf_decay = 1, ["item_"..name.."_leaves"] = 1, flammable = 1, not_in_creative_inventory = 1, },
    is_ground_content = false,
    drop = {
      max_items = 1,
      items = {
        {
          items = {'pmb_trees:' .. node_name .. '_sapling'},
          rarity = 35,
        },
        {
          items = {'pmb_items:stick'},
          rarity = 30,
        },
      },
    },
    sounds = pmb_sounds.default_plant(), -- #TODO add leaf sounds
    _on_node_update = pmb_wood.leaves_on_update,
    on_timer = leaf_decay,
})
end

minetest.register_abm({
  nodenames = {"group:leaf_decay"},
  neighbors = {'air'},
  interval = 10.0,
  chance = 100,
  action = function(pos, node, active_object_count, active_object_count_wider)
    leaf_decay(pos)
  end
})

pmb_wood.register_log(   "Oak", {'pmb_wood_oak_log_top.png', 'pmb_wood_oak_log_top.png', 'pmb_wood_oak_log_side.png'})
pmb_wood.register_leaves_old("Oak", {'pmb_wood_oak_leaves.png'}, {'pmb_wood_oak_leaves_opaque.png'}) -- deprecated, for compat only
pmb_wood.register_leaves("Oak", {'pmb_wood_oak_leaves.png'}, {'pmb_wood_oak_leaves_opaque.png'})
pmb_wood.register_planks("Oak", {'pmb_wood_oak_planks.png'})
pmb_wood.register_plank( "Oak", {'pmb_wood_oak_plank.png'})
minetest.register_alias("pmb_wood:oak_beam", "pmb_wood:oak_planks_beam")

pmb_util.register_all_shapes("pmb_wood:oak_planks", {}, {remove_groups={"planks"}})


pmb_wood.register_log(   "Ash", {'pmb_wood_ash_log_top.png', 'pmb_wood_ash_log_top.png', 'pmb_wood_ash_log_side.png'})
pmb_wood.register_leaves_old("Ash", {'pmb_wood_ash_leaves.png'}, {'pmb_wood_ash_leaves_opaque.png'}) -- deprecated, for compat only
pmb_wood.register_leaves("Ash", {'pmb_wood_ash_leaves.png'}, {'pmb_wood_ash_leaves_opaque.png'})
pmb_wood.register_planks("Ash", {'pmb_wood_ash_planks.png'})
pmb_wood.register_plank( "Ash", {'pmb_wood_ash_plank.png'})
minetest.register_alias("pmb_wood:ash_beam", "pmb_wood:ash_planks_beam")

pmb_util.register_all_shapes("pmb_wood:ash_planks", {}, {remove_groups={"planks"}})


pmb_wood.register_log(   "Spruce", {'pmb_wood_spruce_log_top.png', 'pmb_wood_spruce_log_top.png', 'pmb_wood_spruce_log_side.png'})
pmb_wood.register_leaves_old("Spruce", {'pmb_wood_spruce_leaves.png'}, {'pmb_wood_spruce_leaves_opaque.png'}) -- deprecated, for compat only
pmb_wood.register_leaves("Spruce", {'pmb_wood_spruce_leaves.png'}, {'pmb_wood_spruce_leaves_opaque.png'})
pmb_wood.register_planks("Spruce", {'pmb_wood_spruce_planks.png'})
pmb_wood.register_plank( "Spruce", {'pmb_wood_spruce_plank.png'})
minetest.register_alias("pmb_wood:spruce_beam", "pmb_wood:spruce_planks_beam")

pmb_util.register_all_shapes("pmb_wood:spruce_planks", {}, {remove_groups={"planks"}})



-- CHARCOAL
minetest.register_node('pmb_wood:charcoal_block', {
  description = S("Block of Charcoal"),
  groups = {
    full_solid = 1, nature = 1, item_charcoal_block = 1, oddly_breakable_by_hand = 3,
    cracky = 1, solid = 1, suffocates = 2, flammable = 1, fuel = 60 },
  tiles = {"pmb_charcoal_block.png"},
  drop = "pmb_items:charcoal",
  sounds = pmb_sounds.default_stone(),
})

minetest.register_node('pmb_wood:hot_coals', {
  description = S("Hot Coals"),
  groups = {
    full_solid = 1, nature = 1, item_hot_coals = 1, oddly_breakable_by_hand = 3,
    cracky = 1, solid = 1, suffocates = 2, flammable = 1, fuel = 60 },
  tiles = {"pmb_hot_coals.png"},
  drop = {
    max_items = 1,
    items = {
      {
        items = {'pmb_items:charcoal 1'},
        rarity = 2
      },
      {
        items = {'pmb_items:charcoal 1'},
        rarity = 2
      },
    },
  },
  sounds = pmb_sounds.default_stone(),
  light_source = 6,
  paramtype = "light",
  on_timer = function(pos, time)
    local above = minetest.get_node(vector.offset(pos, 0, 1, 0))
    if minetest.get_item_group(above.name, "fire") == 0
    and not minetest.find_node_near(pos, 2, "group:spreads_fire") then
      minetest.swap_node(pos, {name="pmb_wood:charcoal_block"})
      minetest.get_node_timer(pos):stop()
      return false
    else
      minetest.get_node_timer(pos):set(10,0)
    end
  end,
  on_construct = function(pos)
    minetest.get_node_timer(pos):start(math.random(5, 60))
  end,
  _on_node_update = function(pos)
    local nt = minetest.get_node_timer(pos)
    if nt:is_started() then return false end
    nt:start(math.random(5, 60))
  end,
})

dofile(mod_path .. DIR_DELIM .. "scaffolding.lua")