
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

    local this_biome = 'grasslands_valley'

pmb_biomes.register_biome({
    name = this_biome,

    node_top = 'pmb_soil:grass_variant_4',
    depth_top = 1,

    node_filler = 'pmb_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'pmb_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 20,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 59,
    humidity_point = 6,
}, {"field", "overworld", "clearing", "flowers"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_sch.get_schematic_path

-- minetest.place_schematic(pos, schematic_path, "random", nil, false)

pmb_biomes.add_boulders({
    biomes = {this_biome},
    place_on = {"group:soil", "group:stone"},
    chance = 1,
    height_offset = 0,
})

-- bushes in large sparse clumps
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = {
        offset = -0.1,
        scale = 0.17,
        spread = {x = 10, y = 10, z = 10},
        seed = 354,
        octaves = 2,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})


-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0001,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.001,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"group:grass_block"},
    sidelen = 1,
    noise_params = {
        offset = -0.1,
        scale = 0.2,
        spread = {x = 16, y = 16, z = 16},
        seed = 5546,
        octaves = 2,
        persist = 0.2,
        lucanarity = 2.78,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "pmb_flora:shrub_1",
})
-- bushes in large sparse clumps
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 1,
    noise_params = {
        offset = -0.1,
        scale = 0.2,
        spread = {x = 16, y = 16, z = 16},
        seed = 5546,
        octaves = 2,
        persist = 0.2,
        lucanarity = 2.78,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = 1,
})


local size = 10
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "pmb_soil:grass_variant_1",
    wherein        = {"pmb_soil:dirt_with_grass"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = sealevel,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5937,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = -10,
        scale = 100,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome,"grasslands"},
})

minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "pmb_soil:grass_variant_2",
    wherein		= {"pmb_soil:grass_variant_1"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = sealevel,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 543,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = -10,
        scale = 100,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome,"grasslands"},
})

minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "pmb_soil:grass_variant_3",
    wherein		= {"pmb_soil:grass_variant_1"},
    clust_scarcity	= 100,
    clust_num_ores	= 2,
    clust_size	= 4,
    y_max = alt_max,
    y_min = alt_min,
    biomes = {this_biome,"grasslands"},
})


local function do_rush_grass_stuff(num, seed, offset)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"group:grass_block"},
        sidelen = 1,
        noise_params = {
            offset = -3 + (offset or 0),
            scale = 10,
            spread = {x = 16, y = 16, z = 16},
            seed = seed,
            octaves = 2,
            persist = 0.8,
            lucanarity = 2.78,
        },
        biomes = {this_biome},
        y_max = alt_max+1,
        y_min = sealevel,
        decoration = "pmb_flora:rush_grass_"..num,
    })
end

do_rush_grass_stuff(1, 5546)
do_rush_grass_stuff(0, 5546, 2)

local function do_grass_stuff(num, seed, offset)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"group:grass_block"},
        sidelen = 1,
        noise_params = {
            offset = -0 + (offset or 0) * 0.2,
            scale = 3,
            spread = {x = 16, y = 16, z = 16},
            seed = seed,
            octaves = 2,
            persist = 0.8,
            lucanarity = 2.78,
        },
        biomes = {this_biome},
        y_max = alt_max,
        y_min = sealevel,
        decoration = "pmb_flora:grass_"..num,
    })
end

do_grass_stuff(3, 5546, 2)
do_grass_stuff(2, 5546, 3)
do_grass_stuff(1, 5546, 4)
do_grass_stuff(0, 5546, 6)

