
local adjacent = {
    vector.new( 0, 1, 0),
    vector.new( 0,-1, 0),
    vector.new( 0, 0, 1),
    vector.new( 0, 0,-1),
    vector.new( 1, 0, 0),
    vector.new(-1, 0, 0),
}

function aom_fluidapi.get_liquid_flow_direction(pos)
    local dir = vector.new(0,0,0)
    local node = minetest.get_node(pos)
    for i = 3, #adjacent do
        local d = adjacent[i]
        local n = minetest.get_node(pos + d)
        local ndef = minetest.registered_nodes[n.name]
        if ndef.liquidtype == "flowing" then
            if n.param2 < node.param2 then
                dir = dir + d
            else
                dir = dir - d
            end
        end
    end
    return vector.normalize(dir)
end

function aom_fluidapi.push_by_liquid(object, dtime, strength)
    local pos = object:get_pos()
    local node = minetest.get_node(pos)
    local ndef = minetest.registered_nodes[node.name]
    if ndef.liquidtype == "flowing" then
        local dir = aom_fluidapi.get_liquid_flow_direction(pos)
        local vel = (dir * strength)
        local rvel = object:get_velocity()
        local dist = vector.length(vel) - vector.length(rvel)
        dist = (dist + vector.distance(vel, rvel)) / 2
        vel = vel * (dist)
        if dir then object:add_velocity(vel * (dtime)) end
    end
end
