local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local mushroom_box = {
    type = "fixed",
    fixed = {
        -2/16, -8/16, -2/16,
        2/16, 4/16, 2/16,
    }
}


function pmb_flora.register_mushroom(name, params)
    local node_name = string.lower(name)
    minetest.register_node('pmb_flora:mushroom_'..node_name, {
        description = S(name.." Mushroom"),
        drawtype = "plantlike",
        walkable = false,
        -- waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        inventory_image = "pmb_mushroom_"..node_name..".png",
        wield_image = "pmb_mushroom_"..node_name..".png",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = mushroom_box,
        groups = { nature = 1, attached_node = 1, ["item_mushroom_"..node_name] = 1, snappy = 3, dig_immediate = 3, flora = 1, mushroom = 1, },
        tiles = {"pmb_mushroom_"..node_name..".png"},
        sounds = pmb_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
        on_construct = function(pos)
            local node = minetest.get_node(pos)
            node.param2 = 8 -- this makes it randomly offset horizontally
            minetest.swap_node(pos, node, true)
        end,
        on_secondary_use = params and params.on_secondary_use,
    })
end

pmb_flora.register_mushroom("Brown")
pmb_flora.register_mushroom("Red")
pmb_flora.register_mushroom("White")

pmb_util.register_wield_use_delay("pmb_flora:mushroom_red", {
    windup = 2,
    sound = pmb_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = pmb_food.eat({
        ["poison_3"] = 9+1,
        ["woozy"] = 2,
    })
})
pmb_util.register_wield_use_delay("pmb_flora:mushroom_white", {
    windup = 2,
    sound = pmb_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = pmb_food.eat({
        ["poison_3"] = 9+1,
        ["featherfalling"] = 2,
    })
})
pmb_util.register_wield_use_delay("pmb_flora:mushroom_brown", {
    windup = 2,
    sound = pmb_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = pmb_food.eat({
        ["regeneration_8"] = 8+1,
    })
})

-- grow mushrooms
local mushroom_searchsize = vector.new(3,2,3)
minetest.register_abm({
    nodenames = {'group:mushroom'},
    interval = 30.0,
    chance = 50,
    action = function(pos, node, active_object_count, active_object_count_wider)
        pmb_util.did_abm("mushroom")

        local light = minetest.get_node_light(pos, 0.5)
        if light > 8 then return false end

        local sp1 = vector.subtract(pos, mushroom_searchsize)
        local sp2 = vector.add(pos, mushroom_searchsize)

        local mushrooms = minetest.find_nodes_in_area(sp1, sp2, node.name)
        if #mushrooms > 6 then return end

        local nodes = minetest.find_nodes_in_area_under_air(sp1, sp2, "group:soil")
        local index = math.random(1, #nodes -1)
        if not nodes[index] then return end
        local place_pos = vector.offset(nodes[index], 0, 1, 0)
        if minetest.get_node(place_pos).name == "air" then
            minetest.set_node(place_pos, {name=node.name})
        end
    end,
})

