
local me = pmb_mob_spawn


function pmb_mob_spawn.has_head_room(pos, height)
    for i=0, height do
        local p = vector.offset(pos, 0, i, 0)
        if minetest.get_node(p).name ~= "air" then
            return false
        end
    end
    return true
end

function pmb_mob_spawn.has_light(pos, min, max, time)
    if not min then min = 0 end
    if not max then max = 15 end
    local light = minetest.get_node_light(pos, time)
    if light >= min and light <= max then return true
    else return false end
end
local get_light_at = (minetest.get_natural_light or minetest.get_node_light)
function pmb_mob_spawn.has_natural_light(pos, min, max)
    if not min then min = 0 end
    if not max then max = 15 end
    local light = get_light_at(pos, 0.5)
    if light >= min and light <= max then return true
    else return false end
end

function pmb_mob_spawn.has_nodes_near(pos, dist, groups, min, max)
    if not min then min = 0 end
    if not max then max = 999 end
    local p1 = vector.offset(pos, -dist, -dist, -dist)
    local p2 = vector.offset(pos,  dist,  dist,  dist)
    local n = #minetest.find_nodes_in_area(p1, p2, groups)
    if n > min and n < max then return true
    else return false end
end

function pmb_mob_spawn.has_player_in_range(pos, min, max)
    for _, player in pairs(minetest.get_connected_players()) do
        local p = player:get_pos()
        local dist = p and vector.distance(p, pos)
        if dist and dist <= max and dist >= min then
            return dist
        end
    end
    return false
end
