local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local grass_box = {
    type = "fixed",
    fixed = {
        -6/16, -8/16, -6/16,
        6/16, 2/16, 6/16,
    }
}

local function register_grass(node_name, tiles)
    local name = string.lower(node_name)
    minetest.register_node('pmb_flora:' .. name, {
        description = S("Some grass"),
        drawtype = "plantlike",
        walkable = false,
        waving = 1,
        paramtype = "light",
        -- paramtype2 = "degrotate",
        paramtype2 = "meshoptions",
        param2 = 3 + 8 + 16 + 32,
        inventory_image = "pmb_" .. name .. ".png",
        wield_image = "pmb_" .. name .. ".png",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = grass_box,
        groups = { nature = 1, attached_node = 1, item_burns = 1, item_grass = 1, dig_immediate = 3, flora = 1, decoration = 1, },
        drop = pmb_flora.grass_drops,
        tiles = tiles,
        buildable_to = true,
        sounds = pmb_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
        after_generated = function(pos)
            minetest.swap_node(pos, {
                name = 'pmb_flora:' .. name,
                param2 = 3+8+(math.random(0,1)*16)
            })
        end,
    })
end

register_grass("grass_0", {"pmb_grass_0.png"})
register_grass("grass_1", {"pmb_grass_1.png"})
register_grass("grass_2", {"pmb_grass_2.png"})
register_grass("grass_3", {"pmb_grass_3.png"})
