local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)


minetest.register_node('pmb_stone:stone_brick', {
    description = S("Stone Brick"),
    groups = { full_solid = 1, item_stone_brick = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_stone_brick.png"},
    sounds = pmb_sounds.default_stone(),
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "pmb_stone:cobble"
    minetest.register_craft({
        output = "pmb_stone:stone_brick 4",
        recipe = {
        {g, g},
        {g, g},
        },
    })
end
pmb_util.register_all_shapes("pmb_stone:stone_brick")


minetest.register_node('pmb_stone:stone_brick_fine', {
    description = S("Fine Stone Brick"),
    groups = { full_solid = 1, item_stone_brick_fine = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_stone_brick_fine.png"},
    sounds = pmb_sounds.default_stone(),
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local s = "pmb_stone:cobble"
    local g = "pmb_stone:stone_brick"
    minetest.register_craft({
        output = "pmb_stone:stone_brick_fine 6",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
pmb_util.register_all_shapes("pmb_stone:stone_brick_fine")


minetest.register_node('pmb_stone:stone_brick_ruin', {
    description = S("Ruined Stone Brick"),
    groups = { full_solid = 1, item_stone_brick_ruin = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        {
            name="pmb_stone_brick_ruin.png", align_style="world", scale=4
        }
    },
    sounds = pmb_sounds.default_stone(),
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "pmb_stone:stone_brick"
    minetest.register_craft({
        output = "pmb_stone:stone_brick_ruin 4",
        recipe = {
        {g, g},
        {g, g},
        },
    })
end
pmb_util.register_all_shapes("pmb_stone:stone_brick_ruin")


minetest.register_node('pmb_stone:stone_brick_pillar', {
    description = S("Stone Brick Pillar"),
    groups = { full_solid = 1, item_stone_brick_pillar = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_stone_brick_pillar_top.png", "pmb_stone_brick_pillar_top.png", "pmb_stone_brick_pillar.png"},
    sounds = pmb_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = pmb_util.rotate_and_place,
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "pmb_stone:stone_brick"
    minetest.register_craft({
        output = "pmb_stone:stone_brick_pillar 3",
        recipe = {
        {g},
        {g},
        {g},
        },
    })
end
pmb_util.register_all_shapes("pmb_stone:stone_brick_pillar")


minetest.register_node('pmb_stone:stone_brick_ornate', {
    description = S("Stone Brick Ornate"),
    groups = { full_solid = 1, item_stone_brick_ornate = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_stone_brick_ornate.png"},
    sounds = pmb_sounds.default_stone(),
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "pmb_stone:stone_brick"
    minetest.register_craft({
        output = "pmb_stone:stone_brick_ornate 4",
        recipe = {
        {g, g},
        {g, g},
        },
    })
end
pmb_util.register_all_shapes("pmb_stone:stone_brick_ornate")


minetest.register_node('pmb_stone:stone_brick_lamp', {
    description = S("Stone Brick Lamp"),
    groups = { full_solid = 1, item_stone_brick_lamp = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = pmb_util.node_light_unfck("pmb_stone_stone_brick_lamp.png"),
    sounds = pmb_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "pmb_stone:stone_brick_ornate"
    local l = "pmb_lights:torch"
    minetest.register_craft({
        output = "pmb_stone:stone_brick_lamp 1",
        recipe = {
        {l},
        {g},
        },
    })
end
pmb_util.register_all_shapes("pmb_stone:stone_brick_lamp")


local function place_long_brick(itemstack, placer, pointed_thing)
    local name = itemstack:get_name()
    local def = minetest.registered_nodes[name]
    if minetest.get_node(pointed_thing.under).name == name then
        itemstack:set_name(def._alternate)
        itemstack = minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true}, nil)
        itemstack:set_name(name)
    else
        itemstack = minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true}, nil)
    end
    return itemstack
end

minetest.register_node('pmb_stone:stone_brick_left', {
    _tt_long_desc = S("The Left side of a long stone brick."),
    description = S("Double Stone Brick (left)"),
    groups = { full_solid = 1, item_stone_brick_long = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        -- top
        "pmb_stone_brick_long_end_left.png",
        -- bottom
        "pmb_stone_brick_long_end_left.png",
        -- right / east
        "pmb_stone_brick_long_top.png",
        -- left / west
        "pmb_stone_brick_long_top.png",
        -- behind / north (facedir)
        "pmb_stone_brick_long_end_right.png",
        -- front / south (pointing at player)
        "pmb_stone_brick_long_end_left.png",
    },
    inventory_image = "pmb_stone_brick_long_inv.png^pmb_stone_brick_long_inv_L.png",
    sounds = pmb_sounds.default_stone(),
    paramtype2 = "facedir",
    _alternate = "pmb_stone:stone_brick_right",
    on_place = place_long_brick,
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "pmb_stone:stone_brick"
    minetest.register_craft({
        output = "pmb_stone:stone_brick_left 2",
        recipe = {
        {g, g},
        },
    })
end
minetest.register_node('pmb_stone:stone_brick_right', {
    description = S("Double Stone Brick (right)"),
    _tt_long_desc = S("The right side of a long stone brick."),
    groups = { full_solid = 1, item_stone_brick_long = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        -- top
        "pmb_stone_brick_long_end_right.png",
        -- bottom
        "pmb_stone_brick_long_end_right.png",
        -- right / east
        "pmb_stone_brick_long_top.png",
        -- left / west
        "pmb_stone_brick_long_top.png",
        -- behind / north (facedir)
        "pmb_stone_brick_long_end_left.png",
        -- front / south (pointing at player)
        "pmb_stone_brick_long_end_right.png",
    },
    inventory_image = "pmb_stone_brick_long_inv.png^pmb_stone_brick_long_inv_R.png",
    sounds = pmb_sounds.default_stone(),
    paramtype2 = "facedir",
    _alternate = "pmb_stone:stone_brick_left",
    drop = "pmb_stone:stone_brick_left",
    on_place = place_long_brick,
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
minetest.register_craft({
    output = "pmb_stone:stone_brick_right",
    recipe = {
    {"pmb_stone:stone_brick_left"},
    },
})
minetest.register_craft({
    output = "pmb_stone:stone_brick_left",
    recipe = {
    {"pmb_stone:stone_brick_right"},
    },
})
