local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)


local on_node_update = function(pos, cause, user, count)
    local timer = minetest.get_node_timer(pos)
    if not timer:is_started() then
        timer:start(1.0)
    end
end

local function display_food_node(pos, node)
    local meta = minetest.get_meta(pos)
    local itemstack = meta:get_inventory():get_stack("input", 1)
    local itemstack_out = meta:get_inventory():get_stack("output", 1)

    if node.name ~= "pmb_cooking:spit_meat"
    and (itemstack_out:get_count() > 0
    or itemstack:get_count() > 0) then
        node.name = "pmb_cooking:spit_meat"
        minetest.swap_node(pos, node)
    elseif node.name ~= "pmb_cooking:spit"
    and itemstack_out:get_count() == 0
    and itemstack:get_count() == 0 then
        node.name = "pmb_cooking:spit"
        minetest.swap_node(pos, node)
    end
end

local on_cook = function(pos, node, cooked_item)
    local meta = minetest.get_meta(pos)
    local itemstack = meta:get_inventory():get_stack("input", 1)

    local below = minetest.get_node(vector.offset(pos, 0, -1, 0))
    if minetest.get_item_group(below.name, "fire") == 0 then
        return end

    if itemstack:get_count() == 0 then
            minetest.sound_play("pmb_cooking_finished_all", {
            gain = 0.5,
            pos = pos,
            max_hear_distance = 5,
        })
    end
    minetest.sound_play("pmb_cooking_finished_boil", {
        gain = 0.9,
        pos = pos,
        max_hear_distance = 10,
    })
    for x=0, 3 do
        minetest.add_particle({
            pos = vector.offset(pos, math.random()-0.5, math.random()-0.5, math.random()-0.5),
            velocity = vector.new(0,math.random(),0),
            expirationtime = math.random() * 4,
            size = math.random() * 4,
            collisiondetection = false,
            vertical = false,
            texture = "pmb_cooking_particle_finished_cooking.png^[colorize:#ffffff55:200",
            glow = 14,
        })
    end
end

local cook_group = function(pos)
    local below = minetest.get_node(vector.offset(pos, 0, -1, 0))
    if minetest.get_item_group(below.name, "fire") ~= 0 then
        return "cooker_spit"
    else
        return nil
    end
end

minetest.register_node("pmb_cooking:spit_meat", {
    description = S("Cooking spit"),
    _tt_long_desc = S("Cooks food when placed above a lit fire."),
    groups = { item_cooking_spit = 1, solid = 1, oddly_breakable_by_hand = 2, cracky = 1,
        cooker = 1, cooker_boil = 1, not_in_creative_inventory = 1, },
    drawtype = "mesh",
    use_texture_alpha = "opaque",
    paramtype = "light",
    paramtype2 = "facedir",
    tiles = {"pmb_cooking_spit.png"},
    mesh = "pmb_cooking_spit_meat.b3d",
    sounds = (pmb_sounds and pmb_sounds.default_stone()) or {},
    _on_node_update = on_node_update,
    _on_cook = on_cook,
    _cook_group = cook_group,
    on_timer = pmb_cooking.cooker_node_timer,
    on_construct = pmb_cooking.cooker_on_construct,
    on_punch = function(pos, node, clicker, itemstack, pointed_thing)
        pmb_cooking.cooker_take_item(pos, node, clicker, itemstack, pointed_thing)
        display_food_node(pos, node)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local ret = pmb_cooking.cooker_give_item(pos, node, clicker, itemstack, pointed_thing)
        display_food_node(pos, node)
        return ret
    end,
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    _on_input_item = function(pos, itemstack)
        local ret = pmb_cooking.cooker_offer_item(pos, itemstack)
        local node = minetest.get_node(pos)
        display_food_node(pos, node)
        return ret
    end,
    _on_take_item = function(pos, itemstack, to_pos)
        local node = minetest.get_node(pos)
        display_food_node(pos, node)
        pmb_cooking.update_infotext(pos)
    end,
})
minetest.register_node("pmb_cooking:spit", {
    description = S("Cooking spit"),
    _tt_long_desc = S("Cooks food when placed above a lit fire."),
    groups = { item_cooking_spit = 1, solid = 1, furniture = 1, oddly_breakable_by_hand = 2, cracky = 1, iron = 1, cooker = 1, cooker_boil = 1 },
    drawtype = "mesh",
    use_texture_alpha = "opaque",
    paramtype = "light",
    paramtype2 = "facedir",
    tiles = {"pmb_cooking_spit.png"},
    mesh = "pmb_cooking_spit.b3d",
    drop = "pmb_cooking:spit",
    sounds = (pmb_sounds and pmb_sounds.default_stone()) or {},
    _on_node_update = on_node_update,
    _on_cook = on_cook,
    _cook_group = cook_group,
    on_timer = pmb_cooking.cooker_node_timer,
    on_construct = pmb_cooking.cooker_on_construct,
    on_punch = function(pos, node, clicker, itemstack, pointed_thing)
        pmb_cooking.cooker_take_item(pos, node, clicker, itemstack, pointed_thing)
        display_food_node(pos, node)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local ret = pmb_cooking.cooker_give_item(pos, node, clicker, itemstack, pointed_thing)
        display_food_node(pos, node)
        return ret
    end,
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    _on_input_item = function(pos, itemstack)
        local ret = pmb_cooking.cooker_offer_item(pos, itemstack)
        local node = minetest.get_node(pos)
        display_food_node(pos, node)
        return ret
    end,
    _on_take_item = function(pos, itemstack, to_pos)
        local node = minetest.get_node(pos)
        display_food_node(pos, node)
        pmb_cooking.update_infotext(pos)
    end,
})


-- temporary crafting recipe
if true then
    local s = "pmb_items:stick"
    minetest.register_craft({
        output = "pmb_cooking:spit",
        recipe = {
            {"", s, ""},
            {s, "", s},
        },
    })
end


