
function aom_scrap.formspec_default(fs, x, y)
    table.insert(fs, "style_type[button;bgimg=pmb_inv_btn.png\\^\\[multiply:#712233;bgimg_middle=8;"..
        "bgimg_hovered=pmb_inv_btn.png\\^\\[multiply:#712233;bgimg_pressed=pmb_inv_btn_press.png\\^\\[multiply:#712233;"..
        "bgcolor_hovered=#eee;bgcolor_pressed=#fff]")
    table.insert(fs, "listring[current_player;aom_scrap_trash]")
    table.insert(fs, "listring[current_player;main]")
end

function aom_scrap.scrap_enabled()
    return (
        (minetest.get_modpath("aom_settings") ~= nil)
        and (aom_settings.get_setting(nil, "gameplay_scrap_enabled", false))
    )
end

function aom_scrap.trash_enabled()
    return (
        (minetest.get_modpath("aom_settings") ~= nil)
        and (aom_settings.get_setting(nil, "gameplay_trash_enabled", true))
    )
end

pmb_inventory.register_formspec_process("inventory", "aom_scrap:main", function(flags)
    local fs = {}
    local x = 19.5
    local y = 6.5

    aom_scrap.formspec_default(fs, x, y)

    if aom_scrap.scrap_enabled() then
        table.insert(fs, pmb_inventory.get_9patch(x-0.5, y-0.5, 2, 4, pmb_inventory.get_bg9patch_texture("#993344"), "false", "32"))
        table.insert(fs, pmb_inventory.get_itemslot_array(x, y, 1, 1, false))
        table.insert(fs, "list[current_player;aom_scrap;"..(x)..","..(y)..";1,1;]")
        table.insert(fs, "style_type[button;border=false]")
        table.insert(fs, "button["..(x)..","..(y+1)..";1,1;".."aom_scrap"..";trash]")

        table.insert(fs, pmb_inventory.get_itemslot_array(x, y+2.1, 1, 1, false))
        table.insert(fs, "image["..x..","..(y+2.1)..";1,1;pmb_inv_trash.png^[colorize:#33000070:255]") -- cc445590
        table.insert(fs, "list[current_player;aom_scrap_trash;"..(x)..","..(y+2.1)..";1,1;]")
        return table.concat(fs)
    elseif aom_scrap.trash_enabled() then
        table.insert(fs, pmb_inventory.get_9patch(x-0.5, y-0.5, 2, 3, pmb_inventory.get_bg9patch_texture("#993344"), "false", "32"))

        table.insert(fs, "style_type[button;border=false]")
        table.insert(fs, "button["..(x-0.1)..","..(y)..";1.2,1;".."aom_scrap"..";destroy]")
        table.insert(fs, pmb_inventory.get_itemslot_array(x, y+1.1, 1, 1, false))
        table.insert(fs, "image["..x..","..(y+1.1)..";1,1;pmb_inv_trash.png^[colorize:#33000070:255]") -- cc445590
        table.insert(fs, "list[current_player;aom_scrap_trash;"..(x)..","..(y+1.1)..";1,1;]")
    else
        return ""
    end
    return table.concat(fs)
end)


function aom_scrap.destroy_trash(player)
    local inv = player:get_inventory()
    local stack = inv:get_stack("aom_scrap_trash", 1)
    if stack:get_count() == 0 then return end
    inv:set_stack("aom_scrap_trash", 1, ItemStack(""))
    minetest.sound_play("pmb_fire_extinguish", {
        gain = 0.5 * aom_scrap.get_setting(player, "sound_menu_volume", 1),
        to_player = player:get_player_name(),
    })
    return true
end

pmb_inventory.register_on_formspec_action("_any", "aom_scrap", function(player, formname, fields)
    local inv = player:get_inventory()
    local pos = player:get_pos()
    if not pos then return end
    local sourcestack = inv:get_stack("aom_scrap", 1)
    -- trash
    local trashed = aom_scrap.destroy_trash(player)
    -- scrap
    local scrapped = aom_scrap.scrappify(sourcestack)

    if scrapped then
        inv:set_stack("aom_scrap", 1, ItemStack(""))
        for i, stack in ipairs(scrapped) do
            local leftover = inv:add_item("main", stack)
            if leftover:get_count() > 0 then
                minetest.add_item(pos, leftover)
                leftover:set_count(0)
            end
        end
    elseif trashed then
    else
        minetest.sound_play("pmb_not_allowed", {
            gain = 0.5 * aom_scrap.get_setting(player, "sound_menu_volume", 1),
            to_player = player:get_player_name(),
        })
        return
    end
    minetest.sound_play("aom_igm_click", {
        gain = 1 * aom_scrap.get_setting(player, "sound_menu_volume", 1),
        to_player = player:get_player_name(),
    })
end)

minetest.register_on_joinplayer(function(player, last_login)
    local inv = player:get_inventory()
    inv:set_size("aom_scrap", 1)
    inv:set_size("aom_scrap_trash", 1)
end)
