local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

if minetest.get_modpath("pmb_mob_spawn") then
    local nodes = {
        ["pmb_stone:cobble_moss_1"] = true,
        ["pmb_stone:cobble_moss_2"] = true,
        ["pmb_mirecaves:stone_moss"] = true,
    }
    local biomes = {
        ["boulder_valley"] = true,
        ["boulder_valley_OCEAN"] = true,
        ["siera_mountains"] = true,
        ["siera_plains"] = true,
        ["siera_plains_OCEAN"] = true,
    }
    pmb_mob_spawn.register_mob({
        name = "aom_goblins:goblin",
        groups = {"hostile"},
        biomes = {},
        on_spawn = function(self, pos)
            for i = 0, (math.random(1,4)) do
                local spos = vector.offset(
                    pos,
                    (math.random()*2-1) * 0.4,
                    0.4,
                    (math.random()*2-1) * 0.4
                )
                local obj = minetest.add_entity(spos, "aom_goblins:goblin")
                obj:set_yaw(math.random() * math.pi * 2)
                obj:add_velocity(vector.new(
                    (math.random()*2-1) * 8,
                    1,
                    (math.random()*2-1) * 8
                ))
            end
        end,
        can_spawn = function(pos, spawn_info)
            if not pmb_dimensions.is_in("overworld", pos) then return false end
            if not pmb_mob_spawn.has_head_room(pos, 2) then return false end
            -- not near artificial light, not in sunlight
            local node = minetest.get_node(vector.offset(pos, 0, -1, 0))
            local is_dark = pmb_mob_spawn.has_light(pos, 0, 2, nil)
            local few_enough_near

            if nodes[node.name] then
                if is_dark then
                    return pmb_entity_api.has_mobs_in_radius(pos, 80, {"aom_goblins:goblin"}, 0, 0)
                end
            end
            if (is_dark or (math.random() < 0.05)) and biomes[spawn_info.biome_name] then
                return pmb_entity_api.has_mobs_in_radius(pos, 140, {"aom_goblins:goblin"}, 0, 3)
            end
            return false
        end,
        can_despawn = function(self)
            if self._age and self._age < 120 then return false end
            return true
        end,
    })
end
