# Usage
Provides a centralised system for checking and setting gameplay tags etc.

There is no "register_gamemode", only the `add_gamemode_tags`.

Gamemodes are not run through this API, instead it serves as just a way to declare and compare gamemodes.

### Callbacks
```lua
pmb_gamemodes.register_on_start_gamemode(gamemode:string, func:functionRef)
pmb_gamemodes.register_on_end_gamemode(gamemode:string, func:functionRef)

```

### Setting the gamemode
```lua
pmb_gamemodes.set_gamemode(player:objectRef, gamemode:string)

```
```lua
pmb_gamemodes.get_gamemode(player:objectRef) --> string --> "survival"

```
```lua
pmb_gamemodes.player_has_tag(player:objectRef, tag:string) --> bool

```
```lua
pmb_gamemodes.get_gamemode_tags(gamemode:string) --> table --> {tag=true}

```
```lua
pmb_gamemodes.add_gamemode_tags(gamemode:string, tags:table)
-- e.g.
pmb_gamemodes.add_gamemode_tags("windmills", {
    -- inventory = true,
    -- crafting = false,
    damage = true,
    visible_to_mobs = true,
})
```
