local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)


local glowroot_box = {
  type = "fixed",
  fixed = {
    -3/16, -8/16, -3/16,
     3/16,  6/16,  3/16,
  }
}

local function grow_glowroot(pos, node, active_object_count, active_object_count_wider)
    pmb_util.did_abm("crop")
    local light = minetest.get_node_light(pos, 0.5)
    local def = minetest.registered_nodes[node.name]
    local next_stage = (def and def._growth_stage + 1) or 1
    node.name = "pmb_flora:glowroot_plant_" .. next_stage
    if not minetest.registered_nodes[node.name] then return false end

    minetest.set_node(pos, node)
end

local function random_grow_time()
    return (math.random() * 200 + 300)
end

local glowroot_variants = {}

local drops = {
    full = {
        max_items = 4,
        items = {
            {
                items = {'pmb_flora:glowroot 1'},
            },
            {
                items = {'pmb_flora:glowroot_seeds 1'},
                rarity = 2,
            },
            {
                items = {'pmb_flora:glowroot_seeds 1'},
                rarity = 2,
            },
            {
                items = {'pmb_flora:glowroot_seeds 1'},
                rarity = 4,
            },
        },
    },
    partial = {
        max_items = 1,
        items = {
            {
                items = {'pmb_flora:glowroot_seeds'},
                rarity = 2
            },
        },
    },
}

minetest.register_node("pmb_flora:glowroot_seeds", {
    description = S("Glowroot Seed"),
    _tt_long_desc = S("Can be planted"),
    inventory_image = "pmb_glowroot_seeds.png",
    wield_image = "pmb_glowroot_seeds.png",
    drawtype = "airlike",
    walkable = false,
    paramtype = "light",
    selection_box = {
        type = "fixed",
        fixed = {-0.1, -0.5, -0.1, 0.1, 0.5, 0.1},
    },
    is_ground_content = true,
    sunlight_propagates = true,
    groups = { item_glowroot_seeds = 1, item_burns = 1, player_place_only = 1, seeds = 1, },
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        minetest.set_node(pos, {name=glowroot_variants[1], param2 = 8})
        local timer = minetest.get_node_timer(pos)
        timer:start(random_grow_time())
    end,
    on_place = function(itemstack, placer, pointed_thing)
        return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"stone"})
    end,
})

for i=0, 3 do
    local drop = drops["partial"]
    local tiles = {"pmb_glowroot_plant_" .. i .. ".png"}
    local growing = (i + 1)

    glowroot_variants[#glowroot_variants+1] = 'pmb_flora:glowroot_plant_' .. i

    minetest.register_node('pmb_flora:glowroot_plant_' .. i, {
        description = S("Glowroot Plant"),
        _tt_long_desc = S(""),
        drawtype = "plantlike",
        walkable = false,
        -- waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        inventory_image = "pmb_glowroot_plant_" .. i .. ".png",
        wield_image = "pmb_glowroot_plant_" .. i .. ".png",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = glowroot_box,
        groups = {
            nature = 1, attached_node = 1, item_burns = 1, item_glowroot_plant = 1,
            dig_immediate = 3, flora = 1, growth_stage = i, glowroot_growing = growing, not_in_creative_inventory = 1 },
        _growth_stage = i,
        drop = drop,
        tiles = tiles,
        buildable_to = false,
        sounds = pmb_sounds.default_plant(),
        light_source = 3,
        on_timer = function(pos, elapsed)
            grow_glowroot(pos, minetest.get_node(pos))
            local timer = minetest.get_node_timer(pos)
            timer:start(random_grow_time())
        end,
        _on_node_update = function(pos, cause, user, count, payload)
            local timer = minetest.get_node_timer(pos)
            if timer:is_started() then
                return false
            else
                timer:start(random_grow_time())
                return true
            end
        end,
    })
end

minetest.register_node('pmb_flora:glowroot_plant_4', {
    description = S("Glowroot Plant"),
    _tt_long_desc = S(""),
    drawtype = "mesh",
    mesh = "pmb_glowroot_mature.b3d",
    walkable = false,
    -- waving = 1,
    paramtype = "light",
    paramtype2 = "meshoptions",
    is_ground_content = true,
    sunlight_propagates = true,
    selection_box = glowroot_box,
    groups = {
        nature = 1, attached_node = 1, item_burns = 1, item_glowroot_plant = 1,
        dig_immediate = 3, flora = 1, growth_stage = 4, decoration = 1, },
    _growth_stage = 4,
    drop = drops.full,
    use_texture_alpha = "clip",
    tiles = {
        "pmb_glowroot_mature.png",
    },
    buildable_to = false,
    sounds = pmb_sounds.default_stone(),
    light_source = 10,
})

minetest.register_craftitem("pmb_flora:glowroot", {
    description = S("Glow Root"),
    _tt_long_desc = S("Bright"),
    inventory_image = "pmb_glowroot.png",
    groups = { item_glowroot = 1, craftitem = 1, glowroot = 1, produce = 1, },
})
