local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_node("pmb_rope:chain", {
    description = S("Chain"),
    _tt_long_desc = S("Can be climbed on"),
    groups = { item_chain = 1, solid = 1, snappy = 3, tool = 1, player_place_only = 1, oddly_breakable_by_hand = 1, chain = 1, rope = 1, },
    tiles = { "pmb_rope_chain.png" },
    drawtype = "plantlike",
    collision_box = {0, 0, 0, 0, 0, 0},
    walkable = false,
    floodable = true,
    sunlight_propagates = true,
    paramtype = "light",
    use_texture_alpha = "clip",
    selection_box = {
        type = "fixed",
        fixed = {
            -3/16, -8/16, -3/16,
             3/16,  8/16,  3/16,
        }
    },
    sounds = pmb_sounds.default_metal(),
    climbable = true,
    _on_node_update = function(pos, cause, user, count, payload)
        minetest.after(0.01, pmb_rope.rope_update, pos, cause, user, count, payload)
    end,
    on_place = pmb_rope.rope_place,
    -- on_secondary_use = pmb_rope.on_use,
})

minetest.register_craft({
    output = "pmb_rope:chain 16",
    recipe = {
        {"pmb_items:iron_bar"},
        {"pmb_items:iron_bar"},
        {"pmb_items:iron_bar"},
    }
})
