local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local fire_pit_size = {
    type = "fixed",
    fixed = {-8/16, -8/16, -8/16, 8/16, 0, 8/16},}

local function do_effects(pos)
    pmb_util.did_abm("node effect")
    for i=0, 4 do
        minetest.add_particle({
            pos = vector.offset(pos, math.random()-0.5, math.random()-0.5, math.random()-0.5),
            velocity = vector.new(0,math.random(),0),
            expirationtime = math.random() * 4,
            size = math.random() * 8,
            collisiondetection = false,
            vertical = false,
            texture = "pmb_cooking_particle_finished_cooking.png^[colorize:#44444400:100",
            glow = 14,
        })
        minetest.add_particle({
            pos = vector.offset(pos, math.random()-0.5, math.random()-0.5, math.random()-0.5),
            velocity = vector.new(0,math.random()*3,0),
            expirationtime = math.random() * 1,
            size = math.random()+0.1,
            collisiondetection = false,
            vertical = false,
            texture = "pmb_cooking_particle_finished_cooking.png^[colorize:#ffee8855:200",
            glow = 14,
        })
    end
end

minetest.register_node('pmb_cooking:fire_pit', {
    description = S("Fire Pit"),
    _tt_long_desc = S("Can help provide heat to cooking nodes above it."),
    groups = { item_fire_pit = 1, solid = 1, furniture = 1, oddly_breakable_by_hand = 2, stone = 1, cracky = 1, },
    drawtype = "mesh",
    use_texture_alpha = "opaque",
    tiles = {"pmb_fire_pit.png",},
    mesh = "pmb_fire_pit.b3d",
    sounds = (pmb_sounds and pmb_sounds.default_stone()) or {},
    collision_box = fire_pit_size,
    selection_box = fire_pit_size,
    on_rightclick = pmb_cooking.activate_burner,
    _custom_sounds = {
        passive = {
            name = "pmb_fire_cc0",
            max_hear_distance = 5,
            gain = 0.3,
        },
    },
    _on_input_item = function(pos, itemstack)
        return pmb_cooking.activate_burner(pos, nil, nil, itemstack, nil)
    end,
})

minetest.register_node('pmb_cooking:fire_pit_active', {
    description = 'A pit for fires. Wait how are you carrying around a burning fireplace in your pocket?',
    groups = { item_fire_pit = 1, solid = 1, oddly_breakable_by_hand = 2,
    cooker = 1, cooker_roast = 1, fire = 1, cooker_sound = 1, cracky = 1, not_in_creative_inventory = 1, },
    drawtype = "mesh",
    use_texture_alpha = "clip",
    tiles = {
        "pmb_fire_pit.png^[colorize:#222222:40", -- make the base not as glowy
        {
            name = "pmb_fire.png", -- this is the flame texture
            animation = {
                type = "vertical_frames",
                aspect_w = 16,
                aspect_h = 16,
                length = 0.5,
            },
        },
        "pmb_fire_pit.png",}, -- this is the wood texture
    drop = "pmb_cooking:fire_pit",
    mesh = "pmb_fire_pit_active.b3d",
    light_source = 12,
    paramtype = "light",
    sounds = (pmb_sounds and pmb_sounds.default_stone()) or {},
    _fuel_use = 1,
    _custom_sounds = {
        passive = {
            name = "pmb_fire_cc0",
            max_hear_distance = 5,
            gain = 0.3,
        },
    },
    collision_box = fire_pit_size,
    selection_box = fire_pit_size,

    on_timer = function(pos, elapsed)
        -- some a chance of charcoal for each 300s of fuel
        do_effects(pos)
        pmb_cooking.do_node_sound(pos, "passive")

        local meta = minetest.get_meta(pos)
        local charcoal = meta:get_int("charcoal") or 0
        if charcoal > 0 then
            if math.random() < 0.2 then
                minetest.add_item(vector.offset(pos, math.random()*0.2, 0.5, math.random()*0.2), ItemStack("pmb_items:charcoal"))
            end
            charcoal = math.max(charcoal - 1, 0)
            meta:set_int("charcoal", charcoal)
        end
        -- run the normal func
        return pmb_cooking.burner_on_timer(pos, elapsed)
    end,
    on_construct = function(pos)
        minetest.get_node_timer(pos):start(1)
    end,

    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local meta = minetest.get_meta(pos)
        local wielditem = clicker:get_wielded_item():get_name()
        if minetest.get_item_group(wielditem, "wood_log") ~= 0 then
            local charcoal = meta:get_int("charcoal")
            meta:set_int("charcoal", charcoal + 1)
        end

        return pmb_cooking.activate_burner(pos, node, clicker, itemstack, pointed_thing)
    end,

    on_destruct = function(pos)
        return pmb_cooking.stop_node_sound(pos)
    end,
    _on_input_item = function(pos, itemstack)
        local meta = minetest.get_meta(pos)
        local wielditem = itemstack:get_name()
        if minetest.get_item_group(wielditem, "wood_log") ~= 0 then
            local charcoal = meta:get_int("charcoal")
            meta:set_int("charcoal", charcoal + 1)
        end

        return pmb_cooking.activate_burner(pos, nil, nil, itemstack, nil)
    end,
})

pmb_tcraft.register_craft({
    output = "pmb_cooking:fire_pit",
    items = {
        ["pmb_stone:cobble"] = 5,
    },
})
