
pmb_wrench.pl = {}

function pmb_wrench.sort_positions(v, b)
    return vector.new(
        ((v.x <= b.x) and v.x) or b.x,
        ((v.y <= b.y) and v.y) or b.y,
        ((v.z <= b.z) and v.z) or b.z
    ),
    vector.new(
        ((v.x >= b.x) and v.x) or b.x,
        ((v.y >= b.y) and v.y) or b.y,
        ((v.z >= b.z) and v.z) or b.z
    )
end

-- returns an index list of vectors within a cube defined buy two points
function pmb_wrench.all_nodes_in(v, b)
    local list = {}
    for z=v.z, b.z do
        for y=v.y, b.y do
            for x=v.x, b.x do
                list[#list+1] = vector.new(x,y,z)
            end
        end
    end
    return list
end

function pmb_wrench.get_eyepos(player)
    local eyepos = vector.add(player:get_pos(), vector.multiply(player:get_eye_offset(), 0.1))
    eyepos.y = eyepos.y + player:get_properties().eye_height
    return eyepos
end

function pmb_wrench.get_shell(player)
    local creative = (player and minetest.is_creative_enabled(player:get_player_name()) or false)
    if (not creative) and minetest.get_modpath("pmb_gamemodes") then creative = pmb_gamemodes.player_has_tag(player, "creative") end
    return {
        name = "",
        node = {name="air"},
        build_list = nil,
        ent = {},
        creative = creative
    }
end

function pmb_wrench.remove_all_ents(player)
    for i=1, 2 do
        if pmb_wrench.pl[player].ent[i] then
            pmb_wrench.pl[player].ent[i].object:remove()
            pmb_wrench.pl[player].ent[i] = nil
        end
    end
end

function pmb_wrench.get_tool_range(player)
    local hand = minetest.registered_items[""]
    local wield = player:get_wielded_item():get_definition()
    return math.max(wield.range or 4, hand.range or 4)
end

function pmb_wrench.get_pointed_thing(player, eyepos, liquids)
    if not eyepos then eyepos = pmb_wrench.get_eyepos(player) end
    local range = pmb_wrench.get_tool_range(player)
    local ray = minetest.raycast(eyepos, vector.add(eyepos, vector.multiply(player:get_look_dir(), range)), false, (liquids == true))
    for pointed_thing in ray do
        if pointed_thing.type == "node" then
            return pointed_thing
        end
    end
    return nil
end

local function tex(name)
    return {name,name,name,name,name,name}
end

local textures = {
    tex("pmb_wrench_wrench_ENTITY.png^[multiply:#8df"),
    tex("pmb_wrench_wrench_ENTITY.png^[multiply:#ed8"),
}

function pmb_wrench.get_entity_texture(num)
    return textures[num]
end


local entity = {
    initial_properties = {
        physical = false,
        textures = textures[1],
        visual = "cube",
        visual_size = {x=1.01, y=1.01},
        collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2,},
        use_texture_alpha = true,
        pointable = false,
        glow = 14,
        static_save = false,
    },
    _parent = false,
    _timer = 1,
    _type = 1,
    on_step = function(self, dtime, moveresult)
        if self._timer < 0 then self._timer = 1
        else self._timer = self._timer - dtime return end

        if (not self._parent) or (not pmb_wrench.pl[self._parent]) or (not pmb_wrench.pl[self._parent]["pos"..self._type]) then
            self.object:remove()
            return
        end
    end,
}
minetest.register_entity("pmb_wrench:wrench_ENTITY", entity)
