local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_craftitem("aom_itemframe:frame", {
    description = S("Item Frame"),
    _tt_color = 1,
    _tt_long_desc = S("Holds a visual representation of an item and the item itself."),
    _tt_how_to_use = S("[place] to add item").."\n"..S("[punch] to take item"),
    inventory_image = "aom_itemframe_inventory.png",
    wield_image = "aom_itemframe_inventory.png",
    -- wield_scale = {x=1, y=1, z=1},
    groups = { furniture = 1, disallow_itemframe = 1, },
    on_place = function(itemstack, player, pointed_thing)
        local ret = pmb_util.try_rightclick(itemstack, player, pointed_thing, false)
        if ret then
            return ret
        end
        return aom_itemframe.new_itemframe(itemstack, player, pointed_thing)
    end,
})

if minetest.get_modpath("pmb_tcraft") then
    pmb_tcraft.register_craft({
        output = "aom_itemframe:frame",
        items = {
            ["pmb_items:stick"] = 4,
            ["pmb_items:plant_fibre"] = 4,
            ["pmb_items:iron_sheet"] = 1,
        },
    })
end
