local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

-- handle interactions with `aom_settings`
local has_aom_settings = (minetest.get_modpath("aom_settings") ~= nil)
if not has_aom_settings then return end

aom_igm.register_page_process("main_buttons", function(fs, player, pagename, data)
    data.y = (data.y or -1) + 1
    -- main buttons
    table.insert(fs, "button[-2.2,"..data.y..";4.4,1;player_settings;"..S("settings").."]")
    data.y = data.y + 1
    if minetest.check_player_privs(player, "server") then
        table.insert(fs, "button[-2.2,"..data.y..";4.4,1;server;"..S("server settings").."]")
    end
    data.y = data.y + 1
end)

aom_igm.register_page_action("main", function(player, pagename, fields)
    if fields.player_settings then
        aom_igm.do_sound_click(player, "aom_igm_click")
        aom_settings.form.show_page(player, "player")
    end
    if fields.server then
        aom_igm.do_sound_click(player, "aom_igm_click")
        aom_settings.form.show_page(player, "server")
    end
end)
