
pmb_statusfx.register_status("speed", {
    ----
    fx_allow_player = true,
    -- fx_allow_object = true,
    -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
    fx_only_tick_once = false,
    fx_only_apply_once = true,
    fx_timeout_individual = false,
    -- fx_use_player_functions_for_objects = true,
    ----
    on_apply_player = function(object, count, meta, params)
        meta.speed = math.max(meta.speed or 1, (params.speed or 2))
        playerphysics.add_physics_factor(object, "speed", "pmb_statusfx:speed", meta.speed)
        return false -- true to prevent apply
    end,
    on_remove_player = function(object, count, meta, not_timeout)
        playerphysics.remove_physics_factor(object, "speed", "pmb_statusfx:speed")
        return false -- true to prevent remove
    end,
    on_step_player = function(object, count, meta, dtime)
        return false -- true to remove
    end,
    ----
    hud = pmb_statusfx.hud.make_effect("pmb_status_speed.png")
    ----
})

pmb_statusfx.register_status("slowness", {
    ----
    fx_allow_player = true,
    -- fx_allow_object = true,
    -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
    fx_only_tick_once = false,
    fx_only_apply_once = true,
    fx_timeout_individual = false,
    -- fx_use_player_functions_for_objects = true,
    ----
    on_apply_player = function(object, count, meta, params)
        meta.speed = math.min(meta.speed or 1, (params.speed or 0.5))
        playerphysics.add_physics_factor(object, "speed", "pmb_statusfx:slow", meta.speed)
        return false -- true to prevent apply
    end,
    on_remove_player = function(object, count, meta, not_timeout)
        playerphysics.remove_physics_factor(object, "speed", "pmb_statusfx:slow")
        return false -- true to prevent remove
    end,
    on_step_player = function(object, count, meta, dtime)
        return false -- true to remove
    end,
    ----
    hud = pmb_statusfx.hud.make_effect("pmb_status_slow.png")
    ----
})
