
-- burn items in fire or nodes tagged with `burns_items`
aom_item_entity.LISTEN("should_burn", function(self, node)
    if minetest.get_item_group(node.name, "burns_items") > 0 then return true end
    if minetest.get_item_group(node.name, "fire") > 0 then return true end
end)

aom_item_entity.LISTEN("is_item_flammable", function(self, stack)
    local iname = stack:get_name()
    if (minetest.get_item_group(iname, "flammable") > 0)
    or (minetest.get_item_group(iname, "wood") > 0)
    or (minetest.get_item_group(iname, "food") > 0)
    or (minetest.get_item_group(iname, "item_burns") > 0) then
        return true
    end
end)

-- prevent burning fireproof items
aom_item_entity.LISTEN("should_burn", function(self, node)
    local stack = ItemStack(self.itemstring)
    if minetest.get_item_group(stack:get_name(), "fireproof") > 0 then return false end
    local all_items = not aom_item_entity.get(nil, "item_burn_only_flammable", true)
    local item_flammable = aom_item_entity.CONDITIONAL("is_item_flammable", self, stack)
    if (not all_items) and not item_flammable then
        return false
    end
end)

aom_item_entity.LISTEN("on_burned", function(self)
    local pos = self.object:get_pos()
    minetest.sound_play("pmb_fire_extinguish", {
        pos = pos,
        max_hear_distance = 10,
        gain = aom_item_entity.get(nil, "item_sound", 0.2)
    })
    local dist = 0.2
    local vel = 1
    minetest.add_particlespawner({
        amount = 10,
        time = -1,
        vertical = false,
        texpool = {
            {
                name = "pmb_fire_smoke.png^[multiply:#333",
                alpha_tween = {
                    0.0, 1.0,
                    style = "rev",
                    reps = 1,
                },
                animation = {
                      type = "vertical_frames",
                      aspect_w = 16, aspect_h = 16,
                      length = 1,
                },
            }
        },
        glow = 0,
        minpos = vector.new(-dist, -dist, -dist) + pos,
        maxpos = vector.new( dist,  dist,  dist) + pos,
        minvel = vector.new(-vel*0.2,  vel*0.5, -vel*0.2),
        maxvel = vector.new( vel*0.2,  vel,      vel*0.2),
        minexptime = 0.5,
        maxexptime = 2,
        minsize = 0.5,
        maxsize = 3,
    })
end)

aom_item_entity.LISTEN("on_start_burn", function(self)
    local pos = self.object:get_pos()
    local dist = 0.2
    local vel = 1
    minetest.add_particlespawner({
        amount = 10,
        time = 1,
        vertical = false,
        texpool = {
            {   name = "gm_windmills_rocket_spark.png^[multiply:#fff",
                alpha_tween = {
                    0.0, 1.0, style = "rev", reps = 1}
            },
            {   name = "gm_windmills_rocket_spark.png^[multiply:#fa6",
                alpha_tween = {
                    0.0, 1.0, style = "rev", reps = 1}
            },
            {   name = "gm_windmills_rocket_spark.png^[multiply:#d61",
                alpha_tween = {
                    0.0, 1.0, style = "rev", reps = 1}
            },
        },
        glow = 0,
        minpos = vector.new(-dist, -dist, -dist) + pos,
        maxpos = vector.new( dist,  dist/2,  dist) + pos,
        minvel = vector.new(-vel*0.2,  vel*0.5, -vel*0.2),
        maxvel = vector.new( vel*0.2,  vel,      vel*0.2),
        minexptime = 0.5,
        maxexptime = 2,
        minsize = 0.5,
        maxsize = 2,
    })
end)

aom_item_entity.LISTEN("on_step", function(self, dtime, moveresult, ...)
    if not aom_item_entity.get(nil, "item_burn_in_fire", false) then return end
    -- count down time to burn
    if self._burn_timer then
        self._burn_timer = self._burn_timer - dtime
    end
    if self._burn_timer and (self._burn_timer <= 0) then
        aom_item_entity.SIGNAL("on_burned", self)
        self.object:remove()
        return "_cancel"
    else
        local pos = self.object:get_pos()
        local node = minetest.get_node_or_nil(pos)
        if not node then return end
        local should_burn = aom_item_entity.CONDITIONAL("should_burn", self, node)
        if (not should_burn) and self._burn_timer then self._burn_timer = nil end
        if should_burn and not self._burn_timer then
            self._burn_timer = 1
            aom_item_entity.SIGNAL("on_start_burn", self)
        end
    end
end)
