local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_tool("pmb_wings:canvas", {
    description = S("Canvas Wings"),
    _tt_color = "#f0f",
    _tt_long_desc = "[wip] These are not animated, but work.\n"..
    "Jump while falling to activate, or use [sprint] + [place] then [jump] to slingshot.",
    inventory_image = "pmb_wings_canvas.png",

    _on_equipment_step = function(itemstack, player, dtime)
        -- minetest.log((pmb_wings.get_player_info(player) or {}).last_speed or 0)
        return pmb_wings.on_equipment_step(itemstack, player, dtime)
    end,
    _on_equipped = function(itemstack, player, info)
        if info and not info.is_from_joining then
            minetest.sound_play("pmb_lantern_take_out", {
                gain = 0.14,
                object = player,
            })
        end
        return pmb_wings.on_equipped(itemstack, player, info)
    end,
    _on_unequipped = function(itemstack, player, info)
        return pmb_wings.on_unequipped(itemstack, player)
    end,

    _cooldown = 10,

    _wings_params = {
        max_speed = 25,
        gravity = 0.6,
        max_acceleration = 300,
        deceleration = 0.03,
        auto_pitch_up = 0.6,
        auto_pitch_up_scale_factor = -0.1 / 20, -- per speed

        fall_bonus = 0.5, -- how much accel per pos.y fallen
        climb_penalty = 0.5, -- how much to slow down per pos.y climbed
        -- lift_factor = 0.5,
        -- lift_max = 0.1,
        -- lift_min = 0.0,
        start_mult_y = 0.3, -- for each vel.y
        start_mult_vel = 0.8, -- for each length(vel)
        start_vel_cancel = 0.95, -- cancel out real vel
        start_vel_cancel_max = 10, -- max to cancel Y vel
        start_vel_add = 0.5, -- add more real vel (1 means double cur vel)
        -- low_speed_threshold = 10,
        -- low_speed_bonus = 1.5,

        collision_factor = 0.4,
        collision_threshold = 0.1, -- above this, vel will be mult by above

        pitch_clamp = 0.9,
        pitch_acc = 0.0, -- how much accel per dir.y down
        pitch_acc_bonus = -0.1, -- pretend looking down this much
        pitch_up_penalty = 0.00,
        -- lift_resistance = 0.0, -- resists lift, but doesn't affect inertia
        -- lift_resistance_threshold = 0.3, -- resists lift only when vel.y > -this
        yaw_deceleration = 9, -- per half rotation (pi)
        yaw_deceleration_threshold = 8, -- radians per sec, under this, yaw decel is x / 10

        slingshot_allow = true, -- allows sprint + rclick to slingshot the player
        slingshot_speed = 20, -- overrides speed after slingshot
        slingshot_velocity = 8, -- how much actuall vel to add when starting slingshot; how far up you fling
        slingshot_delay = 2, -- max amount of time before cancelling slingshot
        slingshot_vel_threshold = 200, -- vel.y < this --> start flying
        slingshot_direction = vector.new(0.8, 0.5, 0.8),

        hud = true,
        wind = true,
        fov = true,
        max_fov = 0.5,
    },
    _wings_on_fly = function(itemstack, player)
        minetest.sound_play("pmb_wings_open", {
            gain = 0.9,
            object = player,
            pitch = 0.9 + math.random() * 0.1,
        })
    end,
    _wings_on_land = function(itemstack, player)
    end,

    groups = { wings = 1, armor_chest = 1, tool = 1, item_burns = 1, },
})

if minetest.get_modpath("pmb_tcraft") then
    pmb_tcraft.register_craft({
        output = "pmb_wings:canvas",
        items = {
            ["pmb_items:plant_fibre"] = 20,
            ["pmb_items:iron_bar"] = 4,
        }
    })
end


