local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

aom_gates.register_gate_controller("aom_machines:controller", {
    description = S("Gate Controller"),
    _tt_color = 4,
    _tt_long_desc = S("Cannot be used directly and must be wired up using wirecutters."),
    groups = { cracky = 2, oddly_breakable_by_hand = 3, solid = 1,
        mechanisms = 1, aom_gates_controller = 1, },
    tiles = {"aom_gates_controller.png"},
    sounds = pmb_sounds.default_metal(),
    _gate_no_rightclick = true,
    _gate_open_sound = {name="aom_gates_chain_pulley_heavy", gain=0.5},
})

aom_gates.register_gate_controller("aom_machines:controller_stone", {
    description = S("Gate Controller"),
    _tt_color = 4,
    _tt_long_desc = S("Controls gate nodes, making them physical or non-physical in one direction.") .. "\n" .. S("[place] to activate"),
    groups = { cracky = 2, oddly_breakable_by_hand = 3, solid = 1,
        mechanisms = 1, aom_gates_controller = 1, },
    tiles = {
        "[combine:16x16:0,0=pmb_stone_brick.png^aom_gates_controller_stone_overlay.png"
    },
    sounds = pmb_sounds.default_metal(),
    _gate_open_sound = {name="aom_gates_chain_pulley_heavy", gain=0.5},
})


-- CRAFTING
if aom_machines.has_pmb_tcraft then
    pmb_tcraft.register_craft({
        output = "aom_machines:controller_stone",
        items = {
            ["pmb_stone:stone_brick"] = 1,
            ["pmb_items:iron_bar"] = 1,
        },
    })
    pmb_tcraft.register_craft({
        output = "aom_machines:controller",
        items = {
            ["pmb_stone:stone_brick"] = 1,
            ["pmb_items:iron_bar"] = 1,
        },
    })
end
