local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local pipe_box1 = nil
local pipe_box = nil
if true then
    local pw = 3/16 -- width
    local pl = 8/16 -- length
    pipe_box1 = {
        type = "fixed",
        fixed = {
            -pw, -pw, -pw,
             pw,  pw,  pl
        },
    }
    pipe_box = {
        type = "connected",
        fixed = {
            {
                -pw, -pw, -pw,
                 pw,  pw,  pw
            },
        },
        connect_top = {
            -pw,  -0, -pw,
             pw,  pl,  pw
        },
        connect_bottom = {
            -pw, -pl, -pw,
             pw,   0,  pw
        },
        connect_front = {
            -pw, -pw, -pl,
             pw,  pw,  0
        },
        connect_left = {
            -pl, -pw, -pw,
              0,  pw,  pw
        },
        connect_back = {
            -pw, -pw, -0,
             pw,  pw,  pl
        },
        connect_right = {
             -0, -pw, -pw,
             pl,  pw,  pw
        },
    }
end

local function get_formspec()
    local fs, size = pmb_inventory.player.get_formspec(nil)
    local y = 12-size.y-2
    return table.concat({
        fs,
        pmb_inventory.get_9patch(10, y-1.5, 2, 2, pmb_inventory.get_bg9patch_texture("#8e6e59"), "false", "32"),
        ((pmb_inventory and pmb_inventory.get_itemslot_array(10.5, y-1, 1, 1)) or ""),
        "list[context;main;10.5,"..tostring(y-1)..";1,1;]",
        "listring[context;main]",
        "listring[current_player;main]"
    })
end

local function fix_formspec(pos)
    local meta = minetest.get_meta(pos)
    local formspec = get_formspec()
    if meta:get_string("formspec") == formspec then return end
    meta:set_string("infotext", "Pipe")
    meta:set_string("formspec", formspec)
    local inv = meta:get_inventory()
    inv:set_size("main", 1)
    return true
end

minetest.register_node('pmb_pipes:pipe', {
    description = S("Copper Item Pipe"),
    _tt_color = 3,
    _tt_long_desc = S("Moves items to the next pipe or any inventory with a \"main\" list it's facing."),
    groups = { cracky = 1, oddly_breakable_by_hand = 2, solid = 1, mechanisms = 1, suffocates = 0, pipe = 1},
    tiles = {
        "pmb_pipes_pipe.png^[transformFY",
        "pmb_pipes_pipe.png",
        "pmb_pipes_pipe.png^[transformR90",
        "pmb_pipes_pipe.png^[transformR270",
        "pmb_pipes_siphon.png",
        "pmb_pipes_siphon.png",
    },
    sounds = pmb_sounds.default_wood(),
    paramtype = "light",
    sunlight_propagates = true,
    paramtype2 = "facedir",
    drawtype = "nodebox",
    node_box = pipe_box,
    connects_to = { "group:pipe", "group:storage", "group:chest", "group:cooker" },
    collision_box = pipe_box1,
    selection_box = pipe_box1,
    -- on_place = function(itemstack, placer, pointed_thing)
    --     return pmb_util.rotate_and_place(itemstack, placer, pointed_thing)
    -- end,
    on_place = pmb_util.rotate_and_place_against,
    on_timer = function(pos, elapsed)
        local metavec = pmb_pipes.get_dir_of_node(pos)
        local to_pos = metavec
        if not to_pos then return true end
        to_pos = vector.add(pos, to_pos)
        local ret = pmb_pipes.move_item_to(pos, to_pos, pmb_pipes.item_move_count)
        if ret then
            local behind_pos = vector.add(pos, metavec)
            local nt = minetest.get_node_timer(behind_pos)
            if not nt:is_started() then
                nt:start(1)
            end
        end
        return ret
    end,
    on_construct = function(pos)
        -- tell the game what node it's pointing into
        local node = minetest.get_node(pos)
        local dir = minetest.facedir_to_dir(node.param2)
        pmb_pipes.set_meta_vector(pos, dir)
        -- set up the formspec and stuff
        fix_formspec(pos)
        -- start the timer
        minetest.get_node_timer(pos):start(1.0)
    end,
    on_destruct = function(pos)
        pmb_inventory.drop_contents(pos)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        fix_formspec(pos)
    end,
    _on_node_update = function(pos)
        local nt = minetest.get_node_timer(pos)
        if not nt:is_started() then
            nt:start(1.0)
        end
    end,
    on_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
        pmb_pipes.start_timer(pos)
    end,
    on_metadata_inventory_put = function(pos, listname, index, stack, player)
        pmb_pipes.start_timer(pos)
    end,
    on_metadata_inventory_take = function(pos, listname, index, stack, player)
        pmb_pipes.start_timer(pos)
    end,
    _has_formspec = true,
})

if true then
    local s = "pmb_items:copper_sheet"
    minetest.register_craft({
        output = "pmb_pipes:pipe 16",
        recipe = {
            {"", s, ""},
            { s, "",s},
            {"", s, ""},
        },
    })
end
