local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_alias("pmb_nodes_surface:water_source", "pmb_liquids:water_source")
minetest.register_node("pmb_liquids:water_source", {
    description = S("Water Source"),
    groups = {
        nature = 1, water_source = 1, liquid = 3,
        water = 3, flowing = 0, dynamic_source=1,
    },
    drawtype = "liquid",
    waving = 3,
    tiles = {
        {
            name = "pmb_liquids_water_animated.png",
            backface_culling = false,
            animation = {
                type="vertical_frames",
                aspect_w = 16,
                aspect_h = 16,
                length = 2.0
            },
        },
        {
            name = "pmb_liquids_water_animated.png",
            backface_culling = true,
            animation = {
                type="vertical_frames",
                aspect_w = 16,
                aspect_h = 16,
                length = 2.0
            },
        },
    },
    use_texture_alpha = "blend",
    paramtype = "light",
    walkable = false,
    is_ground_content = false,
    liquid_move_physics = true,
    move_resistance = 1,
    drowning = pmb_liquids.drowning,
    pointable = false,
    diggable = false,
    buildable_to = true,
    liquidtype = "source",
    liquid_viscosity = 0,
    liquid_renewable = (not pmb_fluid_api.enabled),
    liquid_range = 7,
    liquid_alternative_source = "pmb_liquids:water_source",
    liquid_alternative_flowing = "pmb_liquids:water_flowing",
    --_on_node_update = pmb_fluid_api.flow_maybe(0.5)
    post_effect_color = {a=200, r=0x23, g=0x3E, b=0x6C},
    _liquid_type = "water"
})

local flowing_selectionbox = { -0.01, -0.01, -0.01, 0.01, 0.01, 0.01 }
minetest.register_alias("pmb_nodes_surface:water_flowing", "pmb_liquids:water_flowing")
minetest.register_node("pmb_liquids:water_flowing", {
    description = S("Flowing Water"),
    groups = { nature = 1, water_flowing = 1, not_in_creative_inventory = 1, liquid = 3, water = 3, flowing = 1, dynamic_flow=1, },

    special_tiles = {
        {
            name = "pmb_liquids_water_animated.png",
            backface_culling = false,
            animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0}
        },
        {
            name = "pmb_liquids_water_animated.png",
            backface_culling = true,
            animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0}
        }
    },
    tiles = {
        name = "pmb_liquids_water_animated.png",
        backface_culling = false,
        animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0}
    },
    use_texture_alpha = "blend",
    drawtype = "flowingliquid",

    selectionbox = flowing_selectionbox,

    paramtype = "light",
    paramtype2 = "flowingliquid",
    waving = 3,

    walkable = false,
    liquid_move_physics = true,
    move_resistance = 0,
    drowning = pmb_liquids.drowning,
    pointable = false,
    diggable = false,
    buildable_to = true,
    liquidtype = "flowing",
    liquid_viscosity = 0,
    liquid_renewable = (not pmb_fluid_api.enabled),
    liquid_range = 7,
    liquid_alternative_source = "pmb_liquids:water_source",
    liquid_alternative_flowing = "pmb_liquids:water_flowing",
    post_effect_color = {a=150, r=0x23, g=0x3E, b=0x6C},
    _liquid_type = "water"
})

minetest.register_alias("pmb_nodes_surface:river_water_source", "pmb_liquids:river_water_source")
minetest.register_node("pmb_liquids:river_water_source", {
    description = S("River Water Source"),
    groups = { nature = 1, water_source = 1, liquid = 3, water = 3, flowing = 0, },

    tiles = {
        {
            name = "pmb_liquids_water_animated.png",
            backface_culling = false,
            animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0}
        },
        {
            name = "pmb_liquids_water_animated.png",
            backface_culling = true,
            animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0}
        },
    },
    use_texture_alpha = "blend",
    drawtype = "liquid",
    paramtype = "light",
    waving = 3,

    walkable = false,
    is_ground_content = false,
    liquid_move_physics = true,
    move_resistance = 1,
    drowning = pmb_liquids.drowning,
    pointable = false,
    diggable = false,
    buildable_to = true,
    liquidtype = "source",
    liquid_viscosity = 0,
    liquid_renewable = (not pmb_fluid_api.enabled),
    liquid_range = 4,
    liquid_alternative_source = "pmb_liquids:river_water_source",
    liquid_alternative_flowing = "pmb_liquids:river_water_flowing",
})

minetest.register_alias("pmb_nodes_surface:river_water_flowing", "pmb_liquids:river_water_flowing")
minetest.register_node("pmb_liquids:river_water_flowing", {
    description = S("River Water Flowing"),
    groups = { nature = 1, water_flowing = 1, not_in_creative_inventory = 1, liquid = 3, water = 3, flowing = 1, },

    special_tiles = {
        {
            name = "pmb_liquids_water_animated.png",
            backface_culling = false,
            animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0}
        },
        {
            name = "pmb_liquids_water_animated.png",
            backface_culling = true,
            animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0}
        },
    },
    tiles = {
        name = "pmb_liquids_water_animated.png",
        backface_culling = false,
        animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0}
    },
    use_texture_alpha = "blend",
    drawtype = "flowingliquid",

    selectionbox = flowing_selectionbox,

    paramtype = "light",
    paramtype2 = "flowingliquid",
    waving = 3,

    walkable = false,
    is_ground_content = false,
    liquid_move_physics = true,
    move_resistance = 1,
    drowning = pmb_liquids.drowning,
    pointable = false,
    diggable = false,
    buildable_to = true,
    liquidtype = "flowing",
    liquid_viscosity = 0,
    liquid_range = 4,
    liquid_renewable = (not pmb_fluid_api.enabled),
    liquid_alternative_source = "pmb_liquids:river_water_source",
    liquid_alternative_flowing = "pmb_liquids:river_water_flowing",
    _liquid_type = "water"
})

minetest.register_alias("pmb_nodes_surface:lava_source", "pmb_liquids:lava_source")
minetest.register_node("pmb_liquids:lava_source", {
    description = S("Lava Source"),
    groups = { nature = 1, lava_source = 1, liquid = 1, lava = 1, flowing = 0 },

    tiles = {"pmb_liquids_lava.png"},
    use_texture_alpha = "blend",
    drawtype = "liquid",
    paramtype = "light",
    light_source = 13,
    waving = 3,

    walkable = false,
    is_ground_content = false,
    liquid_move_physics = true,
    move_resistance = 1,
    pointable = false,
    diggable = false,
    buildable_to = true,
    liquidtype = "source",
    liquid_renewable = false,
    liquid_viscosity = 2,
    liquid_range = 4,
    damage_per_second = 1, -- #TODO damage
    liquid_alternative_source = "pmb_liquids:lava_source",
    liquid_alternative_flowing = "pmb_liquids:lava_flowing",
    _on_node_update = function(pos, cause, user, count, payload)
        if not cause == "liquid" then return end
        if pmb_util.has_adjacent(pos, "water") > 0 then
            minetest.set_node(pos, {name="pmb_stone:obsidian"}, true)
            return false
        end
    end,
    _liquid_type = "lava"
})

minetest.register_alias("pmb_nodes_surface:lava_flowing", "pmb_liquids:lava_flowing")
minetest.register_node("pmb_liquids:lava_flowing", {
    description = S("Lava Flowing"),
    groups = { nature = 1, lava_flowing = 1, not_in_creative_inventory = 1, liquid = 1, lava = 1, flowing = 1 },

    special_tiles = {
        {
            name = "pmb_liquids_lava.png",
            backface_culling = false,
        },
        {
            name = "pmb_liquids_lava.png",
            backface_culling = true,
        }
    },
    tiles = {"pmb_liquids_lava.png"},
    -- use_texture_alpha = "blend",
    drawtype = "flowingliquid",

    selectionbox = flowing_selectionbox,

    paramtype = "light",
    paramtype2 = "flowingliquid",
    light_source = 13,
    waving = 3,

    walkable = false,
    liquid_move_physics = true,
    move_resistance = 1,
    pointable = false,
    diggable = false,
    buildable_to = true,
    liquidtype = "flowing",
    liquid_renewable = false,
    liquid_viscosity = 2,
    liquid_range = 4,
    damage_per_second = 1, -- #TODO damage
    liquid_alternative_source = "pmb_liquids:lava_source",
    liquid_alternative_flowing = "pmb_liquids:lava_flowing",
    _on_node_update = function(pos, cause, user, count, payload)
        if not cause == "liquid" then return end
        if pmb_util.has_adjacent(pos, "water") > 0 then
            minetest.set_node(pos, {name="pmb_stone:cobble"}, true)
            return false
        end
    end,
    _liquid_type = "lava"
})

if pmb_fluid_api.enabled then
    pmb_fluid_api.register_flow_down("pmb_liquids:water_source", "pmb_liquids:water_flowing")
    pmb_fluid_api.register_flow_down("pmb_liquids:river_water_source", "pmb_liquids:river_water_flowing")
    pmb_fluid_api.register_flow_down("pmb_liquids:lava_source", "pmb_liquids:lava_flowing")
end
