local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

aom_vehicleapi = {}

aom_vehicleapi.enable_debug = false

function aom_vehicleapi.debug_particle(pos, color, time, vel)
    if not aom_vehicleapi.enable_debug then return end -- for debug purposes
    minetest.add_particle({
        size = 2,
        pos = pos,
        texture = "white.png^[colorize:"..(color or "#fff")..":255",
        velocity = vel or vector.new(0, 0, 0),
        expirationtime = time,
        glow = 14,
    })
end

dofile(mod_path .. "/scripts/math.lua")
dofile(mod_path .. "/scripts/physics.lua")
dofile(mod_path .. "/scripts/player_proximity.lua")
dofile(mod_path .. "/scripts/entities.lua")
dofile(mod_path .. "/scripts/controls.lua")
dofile(mod_path .. "/scripts/platforms.lua")
dofile(mod_path .. "/scripts/sounds.lua")
dofile(mod_path .. "/scripts/friction_fix.lua")
dofile(mod_path .. "/scripts/api_main.lua")
