-- don't actually run
do return end

local __my_vehicle = {
    initial_properties = {
        automatic_rotate = 0,
    },
    on_step = function(self, dtime, moveresult)
        local pos = self.object:get_pos()
        if not pos then return end -- check exists

        aom_vehicleapi.do_standing_on_vehicles(self, dtime)
        aom_vehicleapi.manage_automatic_rotate(self, dtime, moveresult)
    end,
    _on_collision_push_sleep = function(self)
    end,
    _on_collision_push = function(self, push, dtime)
    end,
    on_activate = function(self, staticdata, dtime_s)
        aom_vehicleapi.on_activate(self, staticdata, dtime_s)
    end,
    get_staticdata = function(self)
        return aom_vehicleapi.get_staticdata(self)
    end,
    _pmb_statusfx_enable = false,
    _aomv_sail = 0,
    _aomv_steer = 0,
    _aomv_max_speed = 4, -- full running sail
    _aomv_min_speed = 1, -- paddle
    _aomv_max_steer = 0.3, -- radians per sec
    _aomv_anti_drift = 0.5,
    _aomv_wind_pad = 0.4, -- shifts wind factor up by this and squashes it between this and 1
    _aomv_platform_y = 0.3,
    _aom_static_save = {
        "_aomv_sail", "_aomv_steer", "_collision_continue_time",
    },
    _aomv_polygon = {
        {0, 11},
        {2, 8},
        {1.8, 4},
    },
}


__my_vehicle._aomv_pointcloud = {
    {pos = vector.new( 0, 2.4, 12.0), dir = vector.new( 0, 0, 1)},
    {pos = vector.new( 0, 1.4, 11.0), dir = vector.new( 0, 0, 1)},
}

minetest.register_entity("my_mod:my_entity", __my_vehicle)
