
function aom_vehicleapi.get_staticdata(self)
    local data = {}
    if self._aom_static_save ~= nil then
        for i, key in ipairs(self._aom_static_save) do
            if key then
                if minetest.is_player(self[key]) or (type(self[key]) == "table" and self[key].object) then
                    error("NO, YOU CANNOT SERIALIZE AN OBJECT!!! from: " .. key) end
                data[key] = self[key]
            end
        end
    end
    data._age = self._age
    data._auto_rot_saved = self._auto_rot + self.object:get_yaw()
    return minetest.serialize(data)
end

function aom_vehicleapi.on_activate(self, staticdata, dtime_s)
    local data = minetest.deserialize(staticdata)
    if data then
        for key, val in pairs(data) do
            if key then
                self[key] = val
            end
        end
    end
    self._auto_rot = self._auto_rot or 0
    if self._auto_rot_saved then
        self.object:set_yaw(self._auto_rot_saved)
    end
end

---Call this on step in order to capture automatic_rotate so you know how much it has rotated in total
function aom_vehicleapi.manage_automatic_rotate(self, dtime, moveresult)
    if self._auto_rot == nil then self._auto_rot = 0 end
    self._auto_rot = self._auto_rot + self.object:get_properties().automatic_rotate * dtime
    self._auto_rot = self._auto_rot % (math.pi*2)
end

---Gets yaw including that from automatic_rotate
function aom_vehicleapi.get_actual_yaw(self)
    return self.object:get_yaw() + (self._auto_rot or 0)
end

---Completely destroys and then re-creates the entity after some time, or if a new player appears nearby
function aom_vehicleapi.periodic_sync_refresh(self, dtime)
    if self._on_refresh_entity == nil then return end
    self._refresh_timer = (self._refresh_timer or self._aomv_sync_refresh_interval or 300) - dtime
    if self._aomv_has_new_player then
        self._refresh_timer = 0.2
    end
    if self._refresh_timer < 1 and not self._is_being_replaced then
        self._is_being_replaced = true
        if self._on_refresh_start then
            self._on_refresh_start(self)
        end
    elseif self._refresh_timer < 0 then
        self._refresh_timer = 120
        if self._on_refresh_entity(self) then
            return true
        end
    end
    return false
end
