local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local grass_box = {
    type = "fixed",
    fixed = {
        -6/16, -8/16, -6/16,
        6/16, 16/16, 6/16,
    }
}

local on_construct = function(pos)
    local node = minetest.get_node(pos)
    node.param2 = math.random(0, 239)
    minetest.swap_node(pos, node)
end

function pmb_flora.register_shrub(name, tiles)
    minetest.register_node('pmb_flora:' .. name, {
        description = S("Shrub"),
        mesh = "pmb_flora_shrub_0.b3d",
        use_texture_alpha = "clip",
        drawtype = "mesh",
        walkable = false,
        waving = 1, --1
        paramtype = "light",
        paramtype2 = "degrotate",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = grass_box,
        groups = {nature = 1, attached_node = 1, ['item_'..name] = 1, flammable = 1,
        dig_immediate = 3, flora = 1, decoration = 1, player_place_only = 1, },
        tiles = tiles,
        drop = {
          max_items = 20,
          items = {
            {
                items = {"pmb_items:stick 10"},
                rarity = 1,
            },
            {
                items = {"pmb_items:plant_fibre 5"},
                rarity = 1,
            },
          },
        },
        -- buildable_to = true,
        sounds = pmb_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
        after_generated = on_construct,
        on_construct = on_construct,
    })
end

pmb_flora.register_shrub("shrub_0", {"pmb_shrub_0.png"})
pmb_flora.register_shrub("shrub_1", {"pmb_shrub_1.png"})
