local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local arlior_box = {
    type = "fixed",
    fixed = {
      -5/16, -8/16, -5/16,
       5/16, -6/16,  5/16,
    }
}

pmb_underworld.arlior = {}

function pmb_underworld.arlior.register_arlior(name, color, node_name)
    node_name = node_name or string.lower(name)
    minetest.register_node('pmb_underworld:arlior_'..node_name, {
        description = S("Arlior "..name),
        _tt_color = 2,
        drawtype = "plantlike",
        waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        param2 = 8,
        inventory_image = "pmb_underworld_arlior_"..node_name..".png",
        wield_image = "pmb_underworld_arlior_"..node_name..".png",
        walkable = false,
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = arlior_box,
        groups = { nature = 1, attached_node = 1, ["item_arlior_"..node_name] = 1,
            player_place_only = 1, arlior = 1, dig_immediate = 3, flora = 1, },
        tiles = {"pmb_underworld_arlior_"..node_name..".png"},
        sounds = pmb_sounds.default_plant(),
        -- on_place = function(itemstack, placer, pointed_thing)
        --     return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        -- end,
        on_construct = function(pos)
            local node = minetest.get_node(pos)
            node.param2 = 8 -- this makes it randomly offset horizontally
            minetest.swap_node(pos, node, true)
        end,
        -- light_source = 3,
    })
end

pmb_underworld.arlior.register_arlior("Stem", "blue", "stem")
-- pmb_underworld.arlior.register_arlior("Fola", "blue", "fola")

minetest.register_node('pmb_underworld:arlior_fola', {
    description = S("Arlior Fola"),
    _tt_color = 2,
    drawtype = "plantlike",
    waving = 1,
    paramtype = "light",
    paramtype2 = "meshoptions",
    param2 = 8,
    inventory_image = "pmb_underworld_arlior_fola.png",
    wield_image = "pmb_underworld_arlior_fola.png",
    walkable = false,
    is_ground_content = true,
    sunlight_propagates = true,
    selection_box = arlior_box,
    groups = { nature = 1, attached_node = 1, item_arlior_fola = 1,
        arlior = 1, dig_immediate = 3, flora = 1, player_place_only = 1, },
    tiles = {"pmb_underworld_arlior_fola.png"},
    sounds = pmb_sounds.default_plant(),
    -- on_place = function(itemstack, placer, pointed_thing)
    --     return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
    -- end,
    on_construct = function(pos)
        local node = minetest.get_node(pos)
        node.param2 = 8 -- this makes it randomly offset horizontally
        minetest.swap_node(pos, node, true)
    end,
    -- light_source = 3,
})

minetest.register_abm({
    nodenames = {'pmb_underworld:arlior_fola'},
    interval = 20.0,
    chance = 5,
    action = function(pos, node, active_object_count, active_object_count_wider)
        local node_below = minetest.get_node(vector.offset(pos, 0, -1, 0))
        local light = minetest.get_node_light(pos, 0.5)
        local daylight = minetest.get_natural_light(pos, 0.5)
        if light >= 10 and daylight <= 10 and node_below.name == "pmb_underworld:arlior" then
            minetest.set_node(vector.offset(pos, 0, -1, 0), {name="pmb_underworld:arlioran"})
        end
    end,
})



minetest.register_node('pmb_underworld:arlior_mushroom_blue', {
    description = S("Arlior Blue Mushroom"),
    _tt_color = 3,
    drawtype = "plantlike",
    waving = 1,
    paramtype = "light",
    paramtype2 = "meshoptions",
    param2 = 8,
    inventory_image = "pmb_underworld_arlior_mushroom_blue.png",
    wield_image = "pmb_underworld_arlior_mushroom_blue.png",
    walkable = false,
    is_ground_content = true,
    sunlight_propagates = true,
    selection_box = arlior_box,
    groups = { nature = 1, attached_node = 1, item_arlior_mushroom_blue = 1, dig_immediate = 3, flora = 1, },
    tiles = {"pmb_underworld_arlior_mushroom_blue.png"},
    sounds = pmb_sounds.default_plant(),
    -- on_place = function(itemstack, placer, pointed_thing)
    --     return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
    -- end,
    on_construct = function(pos)
        local node = minetest.get_node(pos)
        node.param2 = 8 -- this makes it randomly offset horizontally
        node.param1 = 238
        minetest.swap_node(pos, node, true)
    end,
    light_source = 4,
})

-- grow mushrooms
local mushroom_searchsize = vector.new(3,1,3)
minetest.register_abm({
    nodenames = {'pmb_underworld:arlior_mushroom_blue'},
    interval = 20.0,
    chance = 10,
    action = function(pos, node, active_object_count, active_object_count_wider)
        pmb_util.did_abm("crop")
        local light = minetest.get_node_light(pos, 0.5)
        local daylight = minetest.get_natural_light(pos, 0.5)
        if light < 9 or daylight > 9 then return false end

        local sp1 = vector.subtract(pos, mushroom_searchsize)
        local sp2 = vector.add(pos, mushroom_searchsize)

        local mushrooms = minetest.find_nodes_in_area(sp1, sp2, node.name)
        if #mushrooms > 10 then return end

        local nodes = minetest.find_nodes_in_area_under_air(sp1, sp2, "group:full_solid")
        local index = math.random(1, #nodes -1)
        if not nodes[index] then return end
        local place_pos = vector.offset(nodes[index], 0, 1, 0)
        if minetest.get_node(place_pos).name == "air" then
            if math.random() < 0.2 then
                minetest.set_node(place_pos, {name=node.name})
            else
                minetest.set_node(place_pos, {name="pmb_underworld:arlior_fola"})
            end
        end
    end
})
