aom_item_entity.settings = {}
aom_item_entity.settings.magnet_radius = 3
aom_item_entity.settings.magnet_speed = 8
aom_item_entity.settings.grace_period = 0.05

aom_item_entity.settings.item_pickup_key = "sneak"
aom_item_entity.settings.item_auto_pickup = true
aom_item_entity.settings.item_auto_pickup_delay = 3
aom_item_entity.settings.item_auto_pickup_max_dist = 3
aom_item_entity.settings.item_auto_pickup_max_dist = 2.5
aom_item_entity.settings.graphics_item_lay_flat = true

local has_aom_settings = minetest.get_modpath("aom_settings") ~= nil

-- interface with aom_settings
function aom_item_entity.get(player, key, default)
    if has_aom_settings and (aom_settings.registered_settings[key] ~= nil) then
        local set = aom_settings.get_setting(player, key, default)
        if set ~= nil then return set end
        return default
    else
        local set = aom_item_entity.settings[key]
        if set ~= nil then return set end
        return default
    end
end
function aom_item_entity.set(player, key, value)
    if has_aom_settings and (aom_settings.registered_settings[key] ~= nil) then
        aom_settings.set_setting(player, key, value)
    else
        aom_item_entity.settings[key] = value
    end
end

function aom_item_entity.debug(text)
    if has_aom_settings and not aom_settings.get_setting(nil, "debug_enabled") then return end
    minetest.log(text)
end

-- eye pos of player
function aom_item_entity.get_eyepos(player, offset)
    local eyepos = vector.add(player:get_pos(), vector.multiply(player:get_eye_offset(), 0.1))
    eyepos.y = eyepos.y + player:get_properties().eye_height + (offset or 0)
    return eyepos
end

-- distance without doing squareroot
function aom_item_entity.squaredist(p1, p2)
    return (((p1.x - p2.x) ^ 2) + ((p1.y - p2.y) ^ 2) + ((p1.z - p2.z) ^ 2))
end

-- checks if player has space and is within reach and has settings correct to pick up this item
-- returns true or false
function aom_item_entity.player_can_pickup(self, player)
    local ctrl = player:get_player_control() or {}
    -- for compat with in game settings
    -- test for if it actually has the setting enabled
    local auto_pickup = aom_item_entity.get(player, "item_auto_pickup", false)
    -- no pickup if this player dropped this item within this time
    -- still pick up instantly for things not dropped by the same player though
    local pickup_delay = aom_item_entity.get(player, "item_auto_pickup_delay", 2)
    if pickup_delay <= 0 then pickup_delay = 0.2 end -- prevent drop spam
    local is_dropper = self.dropped_by == player:get_player_name()
    if not ((not is_dropper) or (self.age > pickup_delay)) then return false end
    -- don't pick up items past the player set distance
    local max_dist = aom_item_entity.get(player, "item_auto_pickup_max_dist", 1)
    local pos = self.object:get_pos()
    local ppos = player:get_pos()
    pos.y = ppos.y
    local dist = aom_item_entity.squaredist(pos, ppos)
    if ctrl[aom_item_entity.get(player, "item_pickup_key", "sneak")] and (self.age > 1) and (dist < max_dist^2) then
        return true
    end
    if not (auto_pickup and (dist < max_dist^2)) then return false end
    -- all checks passed, so let the player pick up
    return true
end


-- overwrite old drop func to make it drop from eye pos
function aom_item_entity.new_drop(itemstack, dropper, pos)
	local is_player = dropper and dropper:is_player()
	local p = vector.new(pos)
	local cnt = itemstack:get_count()
	if is_player then
		p = aom_item_entity.get_eyepos(dropper, -0.5)
	end
	local item = itemstack:take_item(cnt)
	local obj = minetest.add_item(p, item)
	if obj then
        local ent = obj:get_luaentity()
		if ent and is_player then
            -- imitate builtin
            local vel = aom_item_entity.get(nil, "item_drop_velocity", 2.9)
			local dir = vector.multiply(dropper:get_look_dir(), vel)
            dir.y = dir.y + 2
			obj:set_velocity(dir)
			ent.dropped_by = dropper:get_player_name()

            aom_item_entity.SIGNAL("on_item_drop", ent, item, dropper)
		end
		return itemstack
	end
    return nil
end
-- overwrite
minetest.item_drop = aom_item_entity.new_drop
