local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

if not pmb_combat.has_pmb_tcraft then
    pmb_tcraft = {
        register_craft = function(...) end
    }
end

pmb_combat.register_swordlike("pmb_combat:iron_sword", {
    description = S("Iron Sword"),
    _tt_color = "#fea",
    inventory_image = "pmb_combat_iron_sword.png",
    range = 0,

    _pmb_combat_get_attack = function(itemstack)
        return {
            base_damage = {
                cut = 9,
                blunt = 3,
            },
            max_base_damage = 8,
            knockback_mult = 5,
        }
    end,
    _windup = 0.3,
})

pmb_tcraft.register_craft({
    output = "pmb_combat:iron_sword",
    items = {
        ["pmb_items:iron_bar"] = 5,
        ["pmb_items:stick"] = 2,
    }
})


pmb_combat.register_swordlike("pmb_combat:bronze_sword", {
    description = S("Bronze Sword"),
    _tt_color = "#fea",
    inventory_image = "pmb_combat_bronze_sword.png",
    range = 0,

    _pmb_combat_get_attack = function(itemstack)
        return {
            base_damage = {
                cut = 5,
                blunt = 2,
            },
            max_base_damage = 5,
            knockback_mult = 2,
        }
    end,
    _windup = 0.2,
    _pmb_combat_block_duration = 0.5,
})

pmb_tcraft.register_craft({
    output = "pmb_combat:bronze_sword",
    items = {
        ["pmb_items:bronze_bar"] = 5,
        ["pmb_items:stick"] = 2,
    }
})


pmb_combat.register_swordlike("pmb_combat:iron_spear", {
    description = S("Iron Spear"),
    _tt_color = "#fea",
    inventory_image = "pmb_combat_iron_spear.png",
    range = 0,
    _can_block_attack = function(stack, player, atk)
        return false
    end,
    on_secondary_use = function(itemstack, user, pointed_thing)
    end,
    _pmb_combat_attack_range = 6,
    _pmb_combat_get_attack = function(itemstack)
        return {
            base_damage = {
                cut = 8,
                blunt = 3,
            },
            max_base_damage = 8,
            knockback_mult = 7,
        }
    end,
    wield_scale = {x=2.5,y=2.5,z=1.5},
    _wield3d_rotation =   {x=-90, y=0, z=-90},
    _wield3d_offset =   {x=0, y=8.0, z=-1.0},
    _wield3d_scale = {x=0.2, y=0.2, z=0.2},
    _override_item_entity = {
        visual_size = {x=0.2, y=0.2, z=0.2},
    },
    _windup = 0.3,
    groups = { combat = 1, spear = 1 },
})

pmb_tcraft.register_craft({
    output = "pmb_combat:iron_spear",
    items = {
        ["pmb_items:iron_bar"] = 5,
        ["pmb_items:stick"] = 2,
    }
})


minetest.register_tool("pmb_combat:test_pants", {
    description = S("Pants"),
    inventory_image = "pmb_combat_test_pants.png",
    _tt_color = 4,

    _on_attack_received = function(victim, stack, atk)
        atk.multiplier.cut = (atk.multiplier.cut or 1) * 0.5
        debug("armor used, received attack")
    end,
    on_step = function(itemstack, player, dtime)
    end,
    groups = { combat = 1, armor_legs = 1 },
})



