local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

pmb_warning = {}

local tmpstr = "\
This game is in development. Breaking changes will happen, and will [n]\
usually (but not guaranteed) be listed in the changelog which you can [n]\
check on Minetest CDB or on the repo: [n]\
[n] [n] [n]\
If in doubt, assume that updating to the next version will corrupt all [n]\
worlds irreversably.[n] [n]\
"..
minetest.colorize("#f35", "The entire design and structure of the game may change without notice.").." [n] [n]"

local labels = ""

for i, substr in ipairs(string.split(tmpstr, "[n]")) do
    labels = labels.."label[7.5,"..(i * 0.3 + 4 - 0.3)..";"..substr.."]"
end

local formspec = table.concat({
    "formspec_version[6]",
    "size[24.00,12.0]",
    "no_prepend[]",
    "bgcolor[#000000]",
    "style_type[image_button;bgimg=blank.png;bgimg_hovered=blank.png]",
    "style_type[image_button;border=false]",
    labels,
    "box[7.5,5.4;8.0,0.6;#111111e0]",
    "style_type[field;border=false;textcolor=#4d8]",
    "field[7.7,5.4;9,0.6;url;;https://codeberg.org/Age_of_Mending/Age_of_Mending/releases]",
    "field_close_on_enter[url;false]",
    "set_focus[start;true]",
    "style_type[label;font_size=*2]",
    "label[9.4,3.8;"..minetest.colorize("#fe5", "ALPHA VERSION").."]",

    "image_button[9.5,8;4,1;gm_windmills_button_start.png;","start","; Ok]",
})



if minetest.get_modpath("aom_settings") then
    aom_settings.register_setting("menu_show_alpha_warning", true, "Show alpha warning to new players")
end

local function show_warning(name)
    minetest.show_formspec(name, "pmb_warning", formspec)
end

minetest.register_on_joinplayer(function(player, last_login)
    local disabled = minetest.get_modpath("aom_settings") and aom_settings.get_setting(nil, "menu_show_alpha_warning", true)
    if (not last_login) and (not disabled) then
        local name = player:get_player_name()
        show_warning(name)
        minetest.chat_send_player(name, "Welcome to Age of Mending! See licenses at " ..
        "https://codeberg.org/Age_of_Mending/Age_of_Mending")
        minetest.chat_send_player(name, "You may also see this warning again by sending the command "..minetest.colorize("#fea", "/alphawarning"))
    end
end)

pmb_util.formspec_actions.register_on_form_fields("pmb_warning", function(player, formname, fields)
    if fields.start then
        minetest.close_formspec(player:get_player_name(), formname)
    end
end)

minetest.register_chatcommand("alphawarning", {
    params = "",
    description = S("Opens the alpha warning you get when you join the first time."),
    privs = {},
    func = function(name, param)
        show_warning(name)
        return true
    end
})
