local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

-- BUTTON
aom_wire.register_button("aom_machines:button", {
    description = S("Button"),
    _tt_long_desc = S(""),
    groups = { oddly_breakable_by_hand = 3, cracky = 1, attached_node = 1, mechanisms = 1, },
    tiles = {
        "pmb_stone_granite_brick_long_end_right.png",
    },
    sounds = minetest.get_modpath("pmb_sounds") and pmb_sounds.default_stone() or nil,
    _aom_wire_activation_sound = {
        press = {
            name = "pmb_wrench_plip",
            gain = 0.1, pitch = 1.2
        },
    }
})

if aom_machines.has_pmb_tcraft then
    pmb_tcraft.register_craft({
        output = "aom_machines:button",
        items = {
            ["pmb_stone:stone_brick"] = 1,
            ["pmb_items:iron_bar"] = 1,
        },
    })
end
