
pmb_statusfx.register_status("burning", {
    ----
    fx_allow_player = true,
    fx_allow_object = true,
    -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
    fx_only_tick_once = false,
    fx_only_apply_once = true,
    fx_timeout_individual = false,
    fx_use_player_functions_for_objects = true,
    ----
    on_apply_player = function(object, count, meta, params)
        meta.until_next_effect = 1
        meta.damage = params.damage or 2
        return false -- true to prevent apply
    end,
    on_remove_player = function(object, count, meta, not_timeout)
        return false -- true to prevent remove
    end,
    on_step_player = function(object, count, meta, dtime)
        meta.until_next_effect = meta.until_next_effect - dtime
        if meta.until_next_effect <= 0 then
            meta.until_next_effect = meta.until_next_effect + 1
            local damage = ((object:is_player() and 1) or 1.5) * (meta.damage or 2)
            object:punch(object, 1, {
                full_punch_interval = 1,
                damage_groups={
                    poison = damage,
            }}, vector.new(
                math.random() * 2 - 1,
                0.5,
                math.random() * 2 - 1
            ))
        end
        return false -- true to remove
    end,
    ----
    hud = pmb_statusfx.hud.make_effect("pmb_status_burning.png")
    ----
})

