local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local uses

local enable_durability = minetest.settings:get("aom_tool_durability") == true

uses = 1024
minetest.register_tool("pmb_hammer:iron_hammer", {
    description = S("Iron Hammer"),
    inventory_image = "pmb_hammer_iron_hammer.png",
    _tt_long_desc = S("Replaces nodes quickly without having to dig and fill nodes back in."),
    _tt_how_to_use = S("[place] to paint node").."\n"..S("[dig] to pick node").."\n"..S("[aux1] to preserve param2 / rotation"),
    -- _tt_uses = uses,
    wield_scale = { x = 1, y = 1, z = 1.7 },
    tool_capabilities = {
        full_punch_interval = 2,
        groupcaps = {
            cracky = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            crumbly = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            choppy = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            snappy = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            dig_immediate = {
                maxlevel = 8,
                uses = ((not enable_durability) and 0) or uses,
            },
        },
        damage_groups = {
            blunt=5,
        },
    },
    groups = { hammer = 2 },
    on_place = pmb_hammer.get_paint_node_from_pointed,
    on_use = pmb_hammer.paint_node,
    on_step = pmb_hammer.paint_node_on_step,
})
if true then
    local m = "pmb_items:stick"
    local b = "pmb_items:iron_bar"
    minetest.register_craft({
        output = "pmb_hammer:iron_hammer",
        recipe = {
        {b, m, b},
        {"",m,""},
        {"",m,""},
        },
    })
end
