local sealevel = pmb_underworld.sea_level
local alt_max = pmb_underworld.alt_max
local alt_min = pmb_underworld.alt_min

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_underworld.get_schematic_path

local this_biome = "underworld_coral"

local c = 3
-------------------------------
------- CORAL CRYSTALS --------
-------------------------------
for i = -1, c do
  minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:lava_coral"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.001 / c,
      spread  = {x=3, y=3, z=3},
      seed    = 543+i*43,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes =  this_biome ,
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("coral_crystal_1"),
    flags = "all_floors, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = i*5
  })
  minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:lava_coral"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.001 / c,
      spread  = {x=3, y=3, z=3},
      seed    = 322+i*65,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes =  this_biome ,
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("coral_crystal_2"),
    flags = "all_floors, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = i*5
  })
end

minetest.register_decoration({
  deco_type = "schematic",
  place_on = {"group:underworld"},
  sidelen = 80,
  -- fill_ratio = 0.0005,
  noise_params = {
    offset  = 0,
    scale   = 0.00005,
    spread  = {x=3, y=3, z=3},
    seed    = 543,
    octaves = 4,
    persist = 1,
    lacunarity = 1,
    flags = "defaults",
  },
  biomes =  this_biome ,
  y_min        = sealevel,
  y_max        = alt_max,
  schematic = sch("struct_1"),
  flags = "all_floors, force_placement, place_center_x, place_center_z",
  rotation = "random",
  place_offset_y = -8
})
