local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local slab_box = {
    -8/16,  -8/16, -8/16,
     8/16,   0,     8/16
}

minetest.register_node("aom_transit:obsidian_dais", {
    description = S("Obsidian Dais"),
    _tt_color = 3,
    groups = { full_solid = 1, item_obsidian_dais = 1, furniture = 1,
        oddly_breakable_by_hand = 3, cracky = 3, solid = 1, suffocates = 2, },
    drawtype = "nodebox",
    paramtype = "light",
    node_box = {
        type = "fixed",
        fixed = slab_box
    },
    use_texture_alpha = "opaque",
    tiles = {
        "aom_transit_obsidian_dais.png",
        "pmb_obsidian.png",
        "aom_transit_obsidian_dais_side.png",
    },
    sounds = pmb_sounds.default_stone(),
})

if true then
    local m = "pmb_underworld:mythril"
    local o = "pmb_stone:obsidian"
    minetest.register_craft({
        output = "aom_transit:obsidian_dais 4",
        recipe = {
            {"", m,"" },
            { o, o, o },
        },
    })
end
