

# Usage


Mobs should have the following.
```lua
    -- needed for it to affect this entity
    _aom_statusfx_enable = true,
    -- optional; if not added, just allows all effects.
    -- this can be used to do whatever, but also returns `true` to prevent applying the effect
    -- example which disables poison effect:
    _aom_statusfx_on_apply = function(self, status_name, meta)
        if status_name == "poison_3" then return true end
        -- true: no apply
        -- else: allow apply
    end,
```

Example effect definition.
```lua
aom_statusfx.register_status("featherfalling", {
    ----
    -- if false, players can't get this effect at all
    fx_allow_player = true,
    -- if false, non-players can't get this effect at all
    fx_allow_object = true,
    -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
    fx_only_tick_once = false,
    -- if true, adding a second effect won't trigger `on_apply_player` etc
    fx_only_apply_once = true,
    -- if true, adding more effects will increase the duration accumulatively
    fx_timeout_individual = false,
    -- set to true if the `on_apply_player` etc functions are player-object agnostic, and work for both.
    -- this will ERROR if you don't design it right
    fx_use_player_functions_for_objects = true,
    ----
    on_apply_player = function(object, count, meta)
        meta.next_time = math.floor(meta.time-1)
        return false -- true to prevent apply
    end,
    on_remove_player = function(object, count, meta, not_timeout)
        return false -- true to prevent remove
    end,
    on_step_player = function(object, count, meta, dtime)
        local vel = object:get_velocity()
        vel.x = 0 vel.z = 0
        if vel.y > 0.0 then
            vel.y = dtime * 10
        elseif vel.y < -0.01 then
            vel.y = -vel.y * 0.07
        end
        object:add_velocity(vel)
        return false -- true to remove
    end,
    ----
    -- object version of the effect, which in this case is left out; it would be identical to the above though.
    on_apply_object = function(object, count, meta) end,
    on_remove_object = function(object, count, meta) end,
    on_step_object = function(object, count, meta, dtime) end,
    ----
    -- the hud to show; this can be custom (hud def), but shouldn't be. Just include the file name of a 16x16 image.
    hud = aom_statusfx.hud.make_effect("aom_status_featherfalling.png")
    ----
})
```

```lua
```

```lua
```

```lua
```