local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)





minetest.register_node('aom_underworld:lava_rock_mythril', {
    description = S("Mythril Ore"),
    _tt_color = 3,
    groups = { full_solid = 1, nature = 1, item_lava_rock_mythril = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 4, solid = 1, suffocates = 2 },
    tiles = {"aom_obsidian.png^aom_underworld_mythril_ore.png"},
    sounds = aom_sounds.default_stone(),
    -- light_source = aom_underworld.lava_rock_light,
    drop = {
        max_items = 1,
        items = {
            {
                items = {'aom_underworld:mythril'},
            },
        },
    },
})
minetest.register_craftitem("aom_underworld:mythril", {
    description = S("Mythril Ore"),
    _tt_color = 3,
    inventory_image = "aom_underworld_mythril.png",
    groups = { item_mythril = 1, craftitem = 1, mythril = 1, nugget = 1, mythril_nugget = 1, },
})


minetest.register_node('aom_underworld:lava_rock_cortite', {
    description = S("Cortite Ore"),
    _tt_color = 3,
    groups = { full_solid = 1, nature = 1, item_lava_rock_cortite = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_rock.png^aom_underworld_cortite_ore.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
    drop = {
        max_items = 1,
        items = {
            {
                items = {'aom_underworld:cortite'},
            },
        },
    },
})
minetest.register_craftitem("aom_underworld:cortite", {
    description = S("Cortite"),
    _tt_color = 3,
    inventory_image = "aom_underworld_cortite.png",
    groups = { item_cortite = 1, craftitem = 1, cortite = 1, nugget = 1, cortite_nugget = 1, },
})
