
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min
local ore_mult = aom_vars.overworld.ore_multiplier

local size = 100

local max = 8
local band_size = 50
local thickness = 10
local offset = 300
for i=0, max do
    minetest.register_ore({
        ore_type      = "stratum",
        ore		      = "aom_stone:loose_stone",
        -- ore		      = "aom_util:light_node_14",
        wherein		  = {"group:stone", "group:dirt"},
        y_min = sealevel - band_size * i - band_size - thickness + offset - 1,
        y_max = sealevel + band_size * i + band_size + thickness + offset + 1,
        clust_scarcity  = 1,
        noise_params    = {
            offset = sealevel - band_size * i + offset,
            scale = band_size, -- this much in either dir but also including the offset position itself
            spread = {x = size, y = size, z = size},
            seed = 65463 + i,
            octaves = 4,
            lacunarity = 1.718,
        },
        np_stratum_thickness = {
            offset = -0,
            scale = thickness, -- this much in either dir but also including the offset position itself
            spread = {x = 20, y = 20, z = 20},
            seed = 87564 + i,
            octaves = 1,
            persistence = 0.2,
            lacunarity = 1.15,
        },
        biomes = {
            "underworld_bridges",
            "ocean",
            "ash_forest",
            "oak_forest_dense_1",
            "ruined_valley",
            "oak_forest",
            "taiga_tall",
            "taiga_tall_dense",
            -- "grasslands_valley",
            "oak_forest_dense",
            "grasslands",
            "ash_forest_dense",
            "desert_dunes",
            "boulder_valley",
        }
    })
end

