local sealevel = aom_underworld.sea_level
local alt_max = aom_underworld.alt_max
local alt_min = aom_underworld.alt_min

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_underworld.get_schematic_path

local this_biome = "underworld_bridges"

-------------------------------
----------- BRIDGES -----------
-------------------------------

local c = 3
for i = 0, c do
  minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:underworld"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.00005,
      spread  = {x=3, y=3, z=3},
      seed    = 453 + i*29,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes = { this_biome },
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("bridge_1"),
    flags = "all_floors, force_placement, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -3 - (c-i) * 3
  })
  minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:underworld"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.00005,
      spread  = {x=3, y=3, z=3},
      seed    = 75 + i*21,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes = { this_biome },
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("bridge_2"),
    flags = "all_floors, force_placement, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -3 - (c-i) * 3
  })
  minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:underworld"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.00005,
      spread  = {x=3, y=3, z=3},
      seed    = 543 + i * 4,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes = { this_biome },
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("struct_1"),
    flags = "all_floors, force_placement, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -8 - (c-i) * 2
  })
  minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:underworld"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.00005,
      spread  = {x=3, y=3, z=3},
      seed    = 7856 + i,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes = { this_biome },
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("struct_2"),
    flags = "all_floors, force_placement, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -3 - (c-i) * 6
  })
end


-- minetest.register_ore({
--   ore_type       = "stratum",
--   ore            = "aom_underworld:glow_rock",
--   wherein        = {"aom_underworld:lava_rock"},
--   y_min = vmin,
--   y_max = vmax,
--   biomes = { this_biome },
-- })