
if (minetest.get_modpath("aom_settings") == nil) then return end

if minetest.get_modpath("age_of_mending") ~= nil then
    -- player
    aom_settings.register_setting("item_auto_pickup", true, "Enable auto pickup")
    aom_settings.register_setting("item_pickup_key", "sneak", "Pickup items key")
    aom_settings.register_setting("item_auto_pickup_delay", 3, "Pickup delay")
    aom_settings.register_setting("item_auto_pickup_max_dist", 2.5, "Pickup max distance")
    -- server
    aom_settings.register_setting("item_punchable", true, "Items can be punched to pickup", "server")
    aom_settings.register_setting("item_scale", 0.3, "Item scale", "server")
    aom_settings.register_setting("item_float_in_water", true, "Items float in water", "server")
    aom_settings.register_setting("item_float_only_if_set", true, "Items float only if group set", "server")
    aom_settings.register_setting("item_water_push_vel", 4, "Items push vel in water", "server")
    aom_settings.register_setting("item_sound", 0.2, "Item move sounds", "server")
    aom_settings.register_setting("item_merge_dist", 0.6, "Item merge distance", "server")
    aom_settings.register_setting("item_lay_flat", true, "Items lay flat", "server")
    aom_settings.register_setting("item_float_height", 0.3, "Item float height on ground", "server")
    aom_settings.register_setting("item_burn_in_fire", true, "Items can burn in fire", "server")
    aom_settings.register_setting("item_burn_only_flammable", true, "Items only burn if marked flammable", "server")
    aom_settings.register_setting("item_rotation", 2, "Items rotate radians per second", "server")
    aom_settings.register_setting("item_initial_rotation", true, "Items have random initial rotation", "server")
else -- if it's not Age of Mending, and is being used as a general api
    -- player
    aom_settings.register_setting("item_auto_pickup", true, "Enable auto pickup")
    aom_settings.register_setting("item_pickup_key", "null", "Pickup items key")
    aom_settings.register_setting("item_auto_pickup_delay", 3, "Pickup delay")
    aom_settings.register_setting("item_auto_pickup_max_dist", 2.0, "Pickup max distance")
    -- server
    aom_settings.register_setting("item_punchable", true, "Items can be punched to pickup", "server")
    aom_settings.register_setting("item_scale", 0.3, "Item scale", "server")
    aom_settings.register_setting("item_float_in_water", true, "Items float in water", "server")
    aom_settings.register_setting("item_float_only_if_set", false, "Items float only if group set", "server")
    aom_settings.register_setting("item_water_push_vel", 4, "Items push vel in water", "server")
    aom_settings.register_setting("item_sound", 0.2, "Item move sounds", "server")
    aom_settings.register_setting("item_merge_dist", 0.6, "Item merge distance", "server")
    aom_settings.register_setting("item_lay_flat", false, "Items lay flat", "server")
    aom_settings.register_setting("item_float_height", 0.3, "Item float height on ground", "server")
    aom_settings.register_setting("item_burn_in_fire", false, "Items can burn in fire", "server")
    aom_settings.register_setting("item_burn_only_flammable", false, "Items only burn if marked flammable", "server")
    aom_settings.register_setting("item_rotation", 2, "Items rotate radians per second", "server")
    aom_settings.register_setting("item_initial_rotation", true, "Items have random initial rotation", "server")
end
