
local function light_gain(player)
    local light = minetest.get_natural_light(vector.offset(player:get_pos(), 0, 1.5, 0), 0.5)
    if not light then return 0 end
    light = math.min(light, 14)
    light = math.max(light / 14, 0.0001)
    return light
end

local function do_rain_sound(player, meta)
    meta.light_gain = light_gain(player)
    if meta.sound_rain then
        minetest.sound_fade(meta.sound_rain, 0.2, 0)
    end
    meta.sound_rain = minetest.sound_play("aom_weather_rain_ambient", {
        gain = 0.0001,
        to_player = player:get_player_name(),
        loop = true,
        pitch = (meta.light_gain or 1) * 0.5 + 0.4,
    })
    minetest.sound_fade(meta.sound_rain, 0.4, meta.light_gain * aom_weather.aom_igm_get_setting(player, "sound_weather_volume", 1))
end

local rain_spawn_size = 30

local function start_weather(player, meta, from_weather)
    if meta.active then return end
    meta.active = true

    meta.particlespawners[#meta.particlespawners+1] = minetest.add_particlespawner({
        amount = 300,
        time = 0,
        collisiondetection = true,
        collision_removal = true,
        object_collision = false,
        attached = player, -- to object ref
        vertical = true, -- If true face player using y axis only:-- If true face player using y axis only:
        texture = "aom_weather_rain.png",
        playername = player:get_player_name(), -- only to this player
        glow = 0,
        minpos = vector.new(-rain_spawn_size*0.5, 30, -rain_spawn_size*0.5),
        maxpos = vector.new(rain_spawn_size*0.5, 30, rain_spawn_size*0.7),
        minvel = vector.new(-1, -30, -1),
        maxvel = vector.new(1, -20, 1),
        minacc = {x=0, y=0, z=0},
        maxacc = {x=0, y=0, z=0},
        minexptime = 3,
        maxexptime = 5,
        minsize = 10,
        maxsize = 10,
    })
    aom_weather.request_sky(player, {
        base_color = "#e3e3e3",
        type = "regular",
        clouds = true,
        sky_color = {
            day_sky = aom_weather.color(125, 150, 175),
            day_horizon = aom_weather.color(125, 150, 175),
            dawn_sky = aom_weather.color(93, 93, 95),
            dawn_horizon = aom_weather.color(110, 87, 102),
            night_sky = aom_weather.color(50, 41, 72),
            night_horizon = aom_weather.color(50, 41, 71),
            indoors = aom_weather.color(59, 59, 59),
            fog_sun_tint = aom_weather.color(38, 57, 101),
            fog_moon_tint = aom_weather.color(38, 57, 101),
            fog_tint_type = "custom",
        }
    })
    player:set_clouds({
        density = 0.5,
        thickness = 20,
        ambient = "#111111",
        color = "#678",
        height = 100,
        speed = {x=4, z=2}
    })
    player:set_sun({
        visible = true,
        texture = "blank.png",
        sunrise_visible = true,
    })
    player:set_moon({
        visible = true,
        texture = "blank.png",
    })
    aom_weather.request_lighting(player, 0.02)
    do_rain_sound(player, meta)
    local light = light_gain(player)
    minetest.sound_fade(meta.sound_rain, 0.2, light)
end

local function stop_weather(player, meta, to_weather)
    if not meta.active then return end
    meta.active = false
    for i, id in ipairs(meta.particlespawners) do
        minetest.delete_particlespawner(id)
    end
    if meta._STOP then
        minetest.sound_stop(meta.sound_rain)
    else
        minetest.sound_fade(meta.sound_rain, 0.1, 0)
    end
    meta.particlespawners = {}
    meta.sound_rain = nil
end

aom_weather.register_weather("light_rain", {
    biomes = {
        -- "tundra",
        -- "underworld_bridges",
        "ocean",
        "ash_forest",
        "oak_forest_dense_1",
        "ruined_valley",
        "oak_forest",
        "taiga_tall",
        -- "underworld_arlior_growth",
        "taiga_tall_dense",
        "grasslands_valley",
        "oak_forest_dense",
        "grasslands",
        -- "underworld",
        "ash_forest_dense",
        -- "desert_dunes",
        -- "underworld_coral",
        "boulder_valley",
        -- "underworld_arlior_meadow",
        -- "tundra_shore",
    },
    chance = 100,
    min_duration = 120, -- sec
    max_duration = 300,
    light_factor = 0.6,
    on_enter_weather = function(player, meta, from_weather)
        start_weather(player, meta, from_weather)
    end,
    on_leave_weather = function(player, meta, to_weather)
        stop_weather(player, meta, to_weather)
        player:set_clouds()
        player:set_moon()
        player:set_sun()
    end,
    on_step = function(player, meta, dtime)
        meta.update_tick = (meta.update_tick or 1) - dtime
        if meta.update_tick <= 0 then
            meta.update_tick = 1
            local light = light_gain(player)
            if light < 0.1 then stop_weather(player, meta, "nil") return
            else start_weather(player, meta, "nil") end
            if light ~= meta.light_gain then
                do_rain_sound(player, meta)
            end
        end
    end,
    next_weather = {
        ["heavy_rain"] = 0.3
    },
    fallbacks = {
        "snow",
        "clear",
    },
})

