
local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_mirecaves.max
local alt_min = aom_mirecaves.min


local segment_count = 10
local segment_height = (aom_mirecaves.max - aom_mirecaves.min) / segment_count



local size = 30
local np = {
    offset = -segment_height,
    scale = segment_height,
    spread = {x = size, y = size, z = size},
    seed = 436,
    octaves = 2,
}
local npt_size = 30
local npt = {
    offset = 10,
    scale = 40,
    spread = {x = npt_size, y = npt_size, z = npt_size*3},
    seed = 768,
    octaves = 2,
    persistence = 0.2
}

local n = aom_mirecaves.worknodes


for i=0, segment_count do
    --------------------------------
    --
    --------------------------------
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = "air",
        wherein        = { n.topsoil2 },
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + aom_mirecaves.min + (i * (segment_height)),
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = aom_mirecaves.biome_list,
    })
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = n.temp_node2,
        wherein        = { n.topsoil, n.topsoil2 },
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + aom_mirecaves.min + (i * (segment_height)) + 1,
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset + 4,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = aom_mirecaves.biome_list,
    })
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = "aom_liquids:river_water_source",
        wherein        = { n.temp_node2 },
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + aom_mirecaves.min + (i * (segment_height)),
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 97,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = aom_mirecaves.biome_list,
    })
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = "aom_mirecaves:stone_moss",
        wherein        = { n.temp_node2 },
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        biomes = aom_mirecaves.biome_list,
    })
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = n.temp_node2,
        wherein        = { n.topsoil, n.topsoil2 },
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + aom_mirecaves.min + (i * (segment_height)) + 1,
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset + 4,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 897,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = aom_mirecaves.biome_list,
    })
    minetest.register_ore({
        ore_type       = "stratum",
        ore            = "air",
        wherein        = { n.topsoil2 },
        y_min = alt_min,
        y_max = alt_max,
        clust_scarcity  = 1,
        noise_params    = {
            offset   = np.offset + aom_mirecaves.min + (i * (segment_height)),
            scale     = np.scale,
            spread   = np.spread,
            seed       = np.seed + i * 15,
            octaves = np.octaves,
        },
        np_stratum_thickness = {
            offset   = npt.offset,
            scale     = npt.scale,
            spread   = npt.spread,
            seed       = npt.seed + i * 434,
            octaves = npt.octaves,
            persistence = npt.persistence,
        },
        biomes = aom_mirecaves.biome_list,
    })
end








