

function aom_cooking.activate_burner(pos, node, clicker, itemstack, pointed_thing)
    local item_name = itemstack:get_name()
    if not node then node = minetest.get_node(pos) end

    -- figure out if this node is active or not
    local active_name, inactive_name
    if string.find(node.name, "_active") then
        active_name = node.name
        inactive_name = string.gsub(node.name, "_active", "")
    else
        inactive_name = node.name
        active_name = node.name .. "_active"
    end

    local fuel_time = math.ceil(minetest.get_item_group(item_name, "fuel"))

    if fuel_time >= 1 then
        if node.name == inactive_name then
            node.name = node.name.."_active"
            minetest.set_node(pos, node)
            aom_cooking.stop_node_sound(pos)
            aom_cooking.do_node_sound(pos)
            aom_node_update.update_node_propagate(pos, "interaction", clicker, 2)
        end

        local meta = minetest.get_meta(pos)
        local timer_elapsed = meta:get_int("time_left") or 0
        meta:set_int("time_left", timer_elapsed + fuel_time)

        local t = minetest.get_node_timer(pos)
        if not t:is_started() then
            t:start(1)
        end

        minetest.sound_play("aom_burner_add_fuel", {
            gain = 0.5,
            pos = pos,
            max_hear_distance = 5,
        })

        itemstack:take_item(1)
    elseif item_name == "" and node.name == active_name then
        -- aom_cooking.deactivate_burner(pos, node)
    end
    return itemstack
end

function aom_cooking.burner_on_timer(pos, elapsed)
    local meta = minetest.get_meta(pos)
    local timer_elapsed = meta:get_int("time_left") or 0
    local fuel_use_mult = (minetest.registered_nodes[minetest.get_node(pos).name] or {})._fuel_use or 1
    fuel_use_mult = fuel_use_mult * elapsed

    meta:set_int("time_left", timer_elapsed - fuel_use_mult)
    if timer_elapsed < 0 then
        aom_cooking.deactivate_burner(pos, minetest.get_node(pos))
        return false
    else
        return true
    end
end

function aom_cooking.deactivate_burner(pos, node)
    node.name = string.gsub(node.name, "_active", "")
    minetest.set_node(pos, node)
    aom_cooking.stop_node_sound(pos)
    return false
end
