local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node("aom_underworld:lava_rock_coral", {
    description = S("Coral Covered Lava Rock"),
    groups = { full_solid = 1, nature = 1, item_lava_rock_coral = 1, underworld = 1, lava_coral = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2, silk_touchable = 1, },
    tiles = {"aom_underworld_lava_rock_coral.png"},
    drop = "aom_underworld:lava_rock",
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_rock_coral")


minetest.register_node("aom_underworld:lava_coral_top", {
    description = S("Coral Covered Lava Rock"),
    groups = { full_solid = 1, nature = 1, item_lava_coral = 1, underworld = 1, lava_coral = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2, fuel = 10 },
    tiles = {
        "aom_underworld_lava_coral_top.png",
        "aom_underworld_lava_coral_sparse.png",
        "aom_underworld_lava_coral_sparse.png^aom_underworld_lava_coral_side.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                rarity = 16,
                items = {"aom_underworld:lava_coral_bulb"},
            },
            {
                rarity = 1,
                items = {"aom_underworld:lava_rock"},
            },
        },
    },
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_coral_top")

minetest.register_node("aom_underworld:lava_coral_sparse", {
    description = S("Coral Covered Lava Rock"),
    groups = { full_solid = 1, nature = 1, item_lava_coral = 1, underworld = 1, lava_coral = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2, fuel = 10 },
    tiles = {
        "aom_underworld_lava_coral_sparse.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                rarity = 16,
                items = {"aom_underworld:lava_coral_bulb"},
            },
            {
                rarity = 1,
                items = {"aom_underworld:lava_rock"},
            },
        },
    },
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_coral_sparse")

minetest.register_node("aom_underworld:lava_coral", {
    description = S("Lava Coral"),
    groups = { full_solid = 1, nature = 1, item_lava_coral = 1, underworld = 1, lava_coral = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2, fuel = 10 },
    tiles = {
        "aom_underworld_lava_coral.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                rarity = 64,
                items = {"aom_underworld:lava_coral_bulb"},
            },
            {
                rarity = 1,
                items = {"aom_underworld:lava_coral"},
            },
        },
    },
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_coral")
