local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local pipe_box1 = nil
local pipe_box = nil
if true then
    local pw = 3/16 -- width
    local pl = 8/16 -- length
    pipe_box1 = {
        type = "fixed",
        fixed = {
            -pw, -pw, -pw,
             pw,  pw,  pl
        },
    }
    pipe_box = {
        type = "connected",
        fixed = {
            {
                -pw, -pw, -pw,
                 pw,  pw,  pw
            },
        },
        connect_top = {
            -pw,  -0, -pw,
             pw,  pl,  pw
        },
        connect_bottom = {
            -pw, -pl, -pw,
             pw,   0,  pw
        },
        connect_front = {
            -pw, -pw, -pl,
             pw,  pw,  0
        },
        connect_left = {
            -pl, -pw, -pw,
              0,  pw,  pw
        },
        connect_back = {
            -pw, -pw, -0,
             pw,  pw,  pl
        },
        connect_right = {
             -0, -pw, -pw,
             pl,  pw,  pw
        },
    }
end

local function get_formspec()
    local fs, size = aom_inventory.player.get_formspec(nil)
    local y = 12-size.y-2
    return table.concat({
        fs,
        aom_inventory.get_9patch(10, y-1.5, 2, 2, aom_inventory.get_bg9patch_texture("#8e6e59"), "false", "32"),
        ((aom_inventory and aom_inventory.get_itemslot_array(10.5, y-1, 1, 1)) or ""),
        "list[context;main;10.5,"..tostring(y-1)..";1,1;]",
        "listring[context;main]",
        "listring[current_player;main]"
    })
end

local function fix_formspec(pos)
    local meta = minetest.get_meta(pos)
    local formspec = get_formspec()
    if meta:get_string("formspec") == formspec then return end
    meta:set_string("infotext", "Pipe")
    meta:set_string("formspec", formspec)
    local inv = meta:get_inventory()
    inv:set_size("main", 1)
    return true
end

minetest.register_node('aom_pipes:pipe', {
    description = S("Copper Item Pipe"),
    _tt_color = 3,
    _tt_long_desc = S("Moves items to the next pipe or any inventory with a \"main\" list it's facing."),
    groups = { cracky = 1, oddly_breakable_by_hand = 2, solid = 1, mechanisms = 1, suffocates = 0, pipe = 1},
    tiles = {
        "aom_pipes_pipe.png^[transformFY",
        "aom_pipes_pipe.png",
        "aom_pipes_pipe.png^[transformR90",
        "aom_pipes_pipe.png^[transformR270",
        "aom_pipes_siphon.png",
        "aom_pipes_siphon.png",
    },
    sounds = aom_sounds.default_wood(),
    paramtype = "light",
    sunlight_propagates = true,
    paramtype2 = "facedir",
    drawtype = "nodebox",
    node_box = pipe_box,
    connects_to = { "group:pipe", "group:storage", "group:chest", "group:cooker" },
    collision_box = pipe_box1,
    selection_box = pipe_box1,
    -- on_place = function(itemstack, placer, pointed_thing)
    --     return aom_util.rotate_and_place(itemstack, placer, pointed_thing)
    -- end,
    on_place = aom_util.rotate_and_place_against,
    on_timer = function(pos, elapsed)
        local metavec = aom_pipes.get_dir_of_node(pos)
        local to_pos = metavec
        if not to_pos then return true end
        to_pos = vector.add(pos, to_pos)
        local ret = aom_pipes.move_item_to(pos, to_pos, aom_pipes.item_move_count)
        if ret then
            local behind_pos = vector.add(pos, metavec)
            local nt = minetest.get_node_timer(behind_pos)
            if not nt:is_started() then
                nt:start(1)
            end
        end
        return ret
    end,
    on_construct = function(pos)
        -- tell the game what node it's pointing into
        local node = minetest.get_node(pos)
        local dir = minetest.facedir_to_dir(node.param2)
        aom_pipes.set_meta_vector(pos, dir)
        -- set up the formspec and stuff
        fix_formspec(pos)
        -- start the timer
        minetest.get_node_timer(pos):start(1.0)
    end,
    on_destruct = function(pos)
        aom_inventory.drop_contents(pos)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        fix_formspec(pos)
    end,
    _on_node_update = function(pos)
        local nt = minetest.get_node_timer(pos)
        if not nt:is_started() then
            nt:start(1.0)
        end
    end,
    on_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
        aom_pipes.start_timer(pos)
    end,
    on_metadata_inventory_put = function(pos, listname, index, stack, player)
        aom_pipes.start_timer(pos)
    end,
    on_metadata_inventory_take = function(pos, listname, index, stack, player)
        aom_pipes.start_timer(pos)
    end,
    _has_formspec = true,
})

if true then
    local s = "aom_items:copper_sheet"
    minetest.register_craft({
        output = "aom_pipes:pipe 16",
        recipe = {
            {"", s, ""},
            { s, "",s},
            {"", s, ""},
        },
    })
end
