
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

function aom_map_base.register_ores_for_node(in_node, flags)
    flags = flags or {}
    flags.skip = flags.skip or {}
    local ore_mult = flags.ore_mult or aom_vars.overworld.ore_multiplier

    -- coal
    if not flags.skip.coal then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore",
        wherein        = {in_node},
        clust_scarcity = 209050 / ore_mult,
        clust_num_ores = 100,
        clust_size     = 8,
        y_min = alt_min,
        y_max = sealevel - 60,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore",
        wherein        = {in_node},
        clust_scarcity = 10900 / ore_mult,
        clust_num_ores = 20,
        clust_size     = 9,
        y_min = alt_min,
        y_max = sealevel,
    })
    -- more coal in the mid range to help new players
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore",
        wherein        = {in_node},
        clust_scarcity = 650 / ore_mult,
        clust_num_ores = 3,
        clust_size     = 3,
        y_min = sealevel - 10,
        y_max = sealevel + 100,
    })
    end

    -- IRON
    if not flags.skip.iron then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1000 / ore_mult,
        clust_num_ores = 2,
        clust_size     = 2,
        y_min = sealevel,
        y_max = alt_max,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1600 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 2,
        y_min = sealevel + 50,
        y_max = alt_max,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1000 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 3,
        y_min = alt_min,
        y_max = sealevel,
    })
    end



    -- TIN
    if not flags.skip.tin then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_tin_ore",
        wherein        = {in_node},
        clust_scarcity = 6650 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel + 10,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_tin_ore",
        wherein        = {in_node},
        clust_scarcity = 3650 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = alt_min,
        y_max = alt_max,
    })
    end


    -- COPPER
    if not flags.skip.copper then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_copper_ore",
        wherein        = {in_node},
        clust_scarcity = 2650 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel + 20,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_copper_ore",
        wherein        = {in_node},
        clust_scarcity = 3650 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = alt_min,
        y_max = alt_max,
    })
    end


    -- LAPIS
    if not flags.skip.lapis then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_lapis_ore",
        wherein        = {in_node},
        clust_scarcity = 5000 / ore_mult,
        clust_num_ores = 5,
        clust_size     = 4,
        y_min = sealevel - 550,
        y_max = sealevel - 40,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_lapis_ore",
        wherein        = {in_node},
        clust_scarcity = 3500 / ore_mult,
        clust_num_ores = 2,
        clust_size     = 4,
        y_min = sealevel + 300,
        y_max = alt_max,
    })
    end


    -- GOLD
    if not flags.skip.gold then
    minetest.register_ore({
        ore_type       = "scatter",
        -- ore            = "aom_util:light_node_14",
        ore            = (flags.node_prefix or in_node).."_gold_ore",
        wherein        = {in_node},
        clust_scarcity = 2500 / ore_mult,
        clust_num_ores = 6,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 40,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        -- ore            = "aom_util:light_node_14",
        ore            = (flags.node_prefix or in_node).."_gold_ore",
        wherein        = {in_node},
        clust_scarcity = 5000 / ore_mult,
        clust_num_ores = 16,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 200,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = "aom_util:light_node_14",
        -- ore            = (flags.node_prefix or in_node).."_gold_ore",
        wherein        = {in_node},
        clust_scarcity = 7000 / ore_mult,
        clust_num_ores = 7,
        clust_size     = 3,
        y_min = sealevel - 6,
        y_max = sealevel + 6,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        -- ore            = "aom_util:light_node_14",
        ore            = (flags.node_prefix or in_node).."_gold_ore",
        wherein        = {in_node},
        clust_scarcity = 3500 / ore_mult,
        clust_num_ores = 3,
        clust_size     = 4,
        y_min = sealevel + 300,
        y_max = alt_max,
    })
    end


    -- DIAMOND
    if not flags.skip.diamond then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 3300 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 50,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 200000 / ore_mult,
        clust_num_ores = 1,
        clust_size     = 1,
        y_min = alt_min,
        y_max = alt_max,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 4650 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = sealevel + math.abs(alt_max - sealevel) * 0.6,
        y_max = alt_max,
    })
    end

    -- IGNIS
    if false and not flags.skip.ignis then -- disabled
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_ignis_ore",
        wherein        = {in_node},
        clust_scarcity = 16050 / ore_mult,
        clust_num_ores = 17,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 50,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_ignis_ore",
        wherein        = {in_node},
        clust_scarcity = 8000 / ore_mult,
        clust_num_ores = 10,
        clust_size     = 3,
        y_min = alt_min,
        y_max = sealevel - 10,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_ignis_ore",
        wherein        = {in_node},
        clust_scarcity = 15650 / ore_mult,
        clust_num_ores = 7,
        clust_size     = 3,
        y_min = sealevel + 200,
        y_max = alt_max,
    })
    end
end

aom_map_base.register_ores_for_node("aom_stone:stone")
aom_map_base.register_ores_for_node("aom_stone:sandstone")
aom_map_base.register_ores_for_node("aom_stone:limestone")
aom_map_base.register_ores_for_node("aom_stone:granite")
aom_map_base.register_ores_for_node("aom_stone:loose_stone")

aom_map_base.register_ores_for_node("aom_soil:sand", {
    skip = {diamond=1, lapis=1, coal=1},
    ore_mult = 0.1,
})
aom_map_base.register_ores_for_node("aom_soil:dirt", {
    skip = {coal=1},
    ore_mult = 0.7,
})
