local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

core.register_node("aom_machines:relay", {
    description = S("Wire Relay"),
    _tt_color = 4,
    _tt_long_desc = S("Gets an input and gives it to its outputs."),
    groups = { cracky = 2, oddly_breakable_by_hand = 3, solid = 1, mechanisms = 1, wire_output = 1, },
    tiles = {"aom_machines_relay.png"},
    sounds = aom_sounds.default_metal(),
	_on_wire_input = function(pos, player, from_pos)
		aom_wire.activate_node_outputs(pos, player)
	end,
})

if aom_machines.has_aom_tcraft then
    aom_tcraft.register_craft({
        output = "aom_machines:relay",
        items = {
            ["aom_items:iron_bar"] = 1,
            ["aom_stone:stone_brick"] = 1,
        },
    })
end
